/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.brandonscore.lib.datamanager;

import codechicken.lib.data.MCDataInput;
import codechicken.lib.data.MCDataOutput;
import codechicken.lib.vec.Vector3;
import com.brandon3055.brandonscore.lib.datamanager.AbstractManagedData;
import com.brandon3055.brandonscore.lib.datamanager.DataFlags;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;

public class ManagedVector3
extends AbstractManagedData<Vector3> {
    private Vector3 value;
    private Vector3 defaultValue;
    protected Function<Vector3, Vector3> validator = null;

    public ManagedVector3(String name, @Nullable Vector3 defaultValue, DataFlags ... flags) {
        super(name, flags);
        this.value = defaultValue;
        this.defaultValue = defaultValue == null ? null : defaultValue.copy();
    }

    public ManagedVector3(String name, DataFlags ... flags) {
        this(name, new Vector3(), flags);
    }

    public Vector3 set(Vector3 value) {
        if (!Objects.equals(this.value, value)) {
            boolean set = true;
            Vector3 prev = this.value;
            this.value = value;
            if (this.dataManager.isClientSide() && this.flags.allowClientControl) {
                this.dataManager.sendToServer(this);
                set = this.ccscsFlag;
            }
            if (set) {
                this.markDirty();
                this.notifyListeners(value);
            } else {
                this.value = prev;
            }
        }
        return this.value;
    }

    @Nullable
    public Vector3 get() {
        return this.value;
    }

    public ManagedVector3 setValidator(Function<Vector3, Vector3> validator) {
        this.validator = validator;
        return this;
    }

    @Override
    public void validate() {
        if (this.validator != null) {
            this.value = this.validator.apply(this.value);
        }
    }

    @Override
    public void toBytes(MCDataOutput output) {
        output.writeBoolean(this.value != null);
        if (this.value != null) {
            output.writeVector(this.value);
        }
    }

    @Override
    public void fromBytes(MCDataInput input) {
        this.value = input.readBoolean() ? input.readVector() : null;
        this.notifyListeners(this.value);
    }

    @Override
    public void toNBT(HolderLookup.Provider provider, CompoundTag compound) {
        CompoundTag nbt = new CompoundTag();
        if (this.value == null) {
            nbt.putBoolean("null", true);
        } else {
            this.value.writeToNBT(compound);
        }
        compound.put(this.name, (Tag)nbt);
    }

    @Override
    public void fromNBT(HolderLookup.Provider provider, CompoundTag compound) {
        CompoundTag nbt;
        this.value = !compound.contains(this.name, 10) ? (this.defaultValue == null ? null : this.defaultValue.copy()) : ((nbt = compound.getCompound(this.name)).contains("null") ? null : Vector3.fromNBT((CompoundTag)nbt));
        this.notifyListeners(this.value);
    }

    public String toString() {
        return this.getClass().getSimpleName() + ":[" + this.getName() + "=" + String.valueOf(this.value) + "]";
    }

    public boolean isNull() {
        return this.value == null;
    }

    public boolean notNull() {
        return this.value != null;
    }
}

