/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.treetap.common.block;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import cy.jdkdigital.treetap.TreeTap;
import cy.jdkdigital.treetap.client.particle.ColoredParticleType;
import cy.jdkdigital.treetap.common.block.entity.SapCollectorBlockEntity;
import cy.jdkdigital.treetap.common.block.entity.TapBlockEntity;
import cy.jdkdigital.treetap.compat.CompatHandler;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class TapBlock
extends BaseEntityBlock {
    public static final MapCodec<TapBlock> CODEC = RecordCodecBuilder.mapCodec(builder -> builder.group((App)TapBlock.propertiesCodec(), (App)Codec.FLOAT.fieldOf("modifier").forGetter(tap -> Float.valueOf(tap.getModifier(null, null)))).apply((Applicative)builder, TapBlock::new));
    private static final Map<Direction, VoxelShape> SHAPES = new HashMap<Direction, VoxelShape>(){
        {
            this.put(Direction.NORTH, Block.box((double)6.0, (double)3.0, (double)9.0, (double)10.0, (double)10.0, (double)16.0));
            this.put(Direction.SOUTH, Block.box((double)6.0, (double)3.0, (double)0.0, (double)10.0, (double)10.0, (double)7.0));
            this.put(Direction.WEST, Block.box((double)9.0, (double)3.0, (double)6.0, (double)16.0, (double)10.0, (double)10.0));
            this.put(Direction.EAST, Block.box((double)0.0, (double)3.0, (double)6.0, (double)7.0, (double)10.0, (double)10.0));
        }
    };
    private final float modifier;
    public static Map<BlockPos, float[]> color = new HashMap<BlockPos, float[]>();

    public TapBlock(BlockBehaviour.Properties properties, float modifier) {
        super(properties);
        this.modifier = modifier;
        this.registerDefaultState((BlockState)((BlockState)this.defaultBlockState().setValue((Property)HorizontalDirectionalBlock.FACING, (Comparable)Direction.NORTH)).setValue((Property)BlockStateProperties.ATTACHED, (Comparable)Boolean.valueOf(false)));
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    public float getModifier(@Nullable Level level, @Nullable BlockPos pos) {
        if (pos == null || level == null) {
            return this.modifier;
        }
        return CompatHandler.adjustTapModifier(level, pos.relative(((Direction)level.getBlockState(pos).getValue((Property)HorizontalDirectionalBlock.FACING)).getOpposite()), this.modifier);
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new TapBlockEntity(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> blockEntityType) {
        return level.isClientSide ? null : TapBlock.createTickerHelper(blockEntityType, (BlockEntityType)((BlockEntityType)TreeTap.TAP_BLOCK_ENTITY.get()), TapBlockEntity::tick);
    }

    public VoxelShape getShape(BlockState state, BlockGetter blockGetter, BlockPos pos, CollisionContext context) {
        return SHAPES.get(state.getValue((Property)HorizontalDirectionalBlock.FACING));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> blockStateBuilder) {
        blockStateBuilder.add(new Property[]{HorizontalDirectionalBlock.FACING}).add(new Property[]{BlockStateProperties.ATTACHED});
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        if (context.getClickedFace().getAxis().isHorizontal()) {
            return (BlockState)this.defaultBlockState().setValue((Property)HorizontalDirectionalBlock.FACING, (Comparable)context.getClickedFace());
        }
        return this.defaultBlockState();
    }

    @Nonnull
    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    public void tick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        if (!state.canSurvive((LevelReader)level, pos)) {
            level.destroyBlock(pos, true);
        }
    }

    public boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        BlockPos attachedPos = pos.relative(((Direction)state.getValue((Property)HorizontalDirectionalBlock.FACING)).getOpposite());
        if (level.getBlockState(attachedPos).is(TreeTap.TAPPABLE)) {
            return CompatHandler.isValidTree(level, attachedPos);
        }
        return false;
    }

    protected ItemInteractionResult useItemOn(ItemStack pStack, BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, InteractionHand pHand, BlockHitResult pHitResult) {
        if (pLevel.getBlockState(pPos.below()).isAir()) {
            BlockState collectorState;
            Object object = pPlayer.getItemInHand(pHand).is(TreeTap.METAL_BUCKETS) ? ((Block)TreeTap.SAP_COLLECTOR.get()).defaultBlockState() : (collectorState = pPlayer.getItemInHand(pHand).is(TreeTap.WOODEN_BUCKETS) ? ((Block)TreeTap.WOODEN_SAP_COLLECTOR.get()).defaultBlockState() : null);
            if (collectorState != null) {
                if (!pLevel.isClientSide) {
                    pLevel.setBlockAndUpdate(pPos.below(), (BlockState)collectorState.setValue((Property)HorizontalDirectionalBlock.FACING, (Comparable)((Direction)pState.getValue((Property)HorizontalDirectionalBlock.FACING))));
                    if (!pPlayer.isCreative()) {
                        pPlayer.getItemInHand(pHand).shrink(1);
                    }
                }
                pPlayer.swing(pHand);
                return ItemInteractionResult.CONSUME;
            }
        }
        return super.useItemOn(pStack, pState, pLevel, pPos, pPlayer, pHand, pHitResult);
    }

    public void neighborChanged(BlockState state, Level level, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        BlockEntity blockEntity;
        super.neighborChanged(state, level, pos, block, fromPos, isMoving);
        if (!(level.getBlockEntity(pos.below()) instanceof SapCollectorBlockEntity) && (blockEntity = level.getBlockEntity(pos)) instanceof TapBlockEntity) {
            TapBlockEntity tapBlockEntity = (TapBlockEntity)blockEntity;
            tapBlockEntity.reset();
            level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)BlockStateProperties.ATTACHED, (Comparable)Boolean.valueOf(false)));
        }
        if (!level.isClientSide) {
            level.scheduleTick(pos, (Block)this, 4);
        }
    }

    private static float[] getParticleColor(BlockPos pos) {
        return color.get(pos);
    }

    private static boolean hasParticleColor(BlockPos pos) {
        return color.containsKey(pos);
    }

    public void animateTick(BlockState state, Level level, BlockPos pos, RandomSource random) {
        if (((Boolean)state.getValue((Property)BlockStateProperties.ATTACHED)).booleanValue()) {
            for (int i = 0; i < random.nextInt(1) + 1; ++i) {
                this.trySpawnDripParticles(level, pos, state);
            }
        }
    }

    private void trySpawnDripParticles(Level level, BlockPos pos, BlockState state) {
        if (!(level.random.nextFloat() < 0.3f)) {
            this.spawnParticle(level, pos, state);
        }
    }

    private void spawnParticle(Level level, BlockPos pos, BlockState state) {
        ColoredParticleType particle = (ColoredParticleType)((Object)TreeTap.COLORED_DRIP_PARTICLE.get());
        if (TapBlock.hasParticleColor(pos)) {
            particle.setColor(TapBlock.getParticleColor(pos));
        } else {
            particle.setColor(new float[]{0.92f, 0.782f, 0.72f});
        }
        float xd = switch ((Direction)state.getValue((Property)HorizontalDirectionalBlock.FACING)) {
            case Direction.EAST -> 0.41f;
            case Direction.WEST -> 0.59f;
            default -> 0.5f;
        };
        float zd = switch ((Direction)state.getValue((Property)HorizontalDirectionalBlock.FACING)) {
            case Direction.NORTH -> 0.59f;
            case Direction.SOUTH -> 0.41f;
            default -> 0.5f;
        };
        level.addParticle((ParticleOptions)particle, (double)pos.getX() + (double)xd, (double)pos.getY() + 0.1875, (double)pos.getZ() + (double)zd, 0.0, 0.0, 0.0);
    }
}

