/*
 * Decompiled with CFR 0.152.
 */
package com.hrznstudio.titanium.component.button;

import com.hrznstudio.titanium.api.IFactory;
import com.hrznstudio.titanium.api.client.IScreenAddon;
import com.hrznstudio.titanium.api.client.IScreenAddonProvider;
import com.hrznstudio.titanium.client.screen.addon.BasicButtonAddon;
import java.util.Collections;
import java.util.List;
import java.util.function.BiConsumer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.player.Player;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class ButtonComponent
implements IScreenAddonProvider {
    private final int posX;
    private final int posY;
    private final int sizeX;
    private final int sizeY;
    private int id;
    private BiConsumer<Player, CompoundTag> serverPredicate;

    public ButtonComponent(int posX, int posY, int sizeX, int sizeY) {
        this.posX = posX;
        this.posY = posY;
        this.sizeX = sizeX;
        this.sizeY = sizeY;
        this.id = -1;
    }

    public ButtonComponent setPredicate(BiConsumer<Player, CompoundTag> serverPredicate) {
        this.serverPredicate = serverPredicate;
        return this;
    }

    public void onButtonClicked(Player entity, CompoundTag information) {
        if (this.serverPredicate != null) {
            this.serverPredicate.accept(entity, information);
        }
    }

    public int getPosX() {
        return this.posX;
    }

    public int getPosY() {
        return this.posY;
    }

    public int getSizeX() {
        return this.sizeX;
    }

    public int getSizeY() {
        return this.sizeY;
    }

    public int getId() {
        return this.id;
    }

    public ButtonComponent setId(int id) {
        this.id = id;
        return this;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public List<IFactory<? extends IScreenAddon>> getScreenAddons() {
        return Collections.singletonList(() -> new BasicButtonAddon(this));
    }
}

