/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.capability;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import net.covers1624.quack.util.SneakyUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.neoforged.neoforge.capabilities.BlockCapability;
import net.neoforged.neoforge.capabilities.ICapabilityInvalidationListener;
import org.jetbrains.annotations.Nullable;

public class CapabilityCache {
    private final SideCache[] cache = new SideCache[7];
    @Nullable
    private ServerLevel level;
    @Nullable
    private BlockPos pos;
    private int moveCookie;

    public CapabilityCache() {
        for (int i = 0; i < this.cache.length; ++i) {
            this.cache[i] = new SideCache();
        }
    }

    public CapabilityCache(ServerLevel level, BlockPos pos) {
        this();
        this.setLevelPos(level, pos);
    }

    public void setLevelPos(ServerLevel level, BlockPos pos) {
        this.clear();
        this.level = level;
        this.pos = pos;
        ++this.moveCookie;
    }

    public void clear() {
        for (SideCache sideCache : this.cache) {
            sideCache.cache.clear();
            sideCache.listener = null;
        }
    }

    public <T> T getCapabilityOr(BlockCapability<T, Direction> capability, Direction to, T default_) {
        T ret = this.getCapability(capability, to);
        if (ret == null) {
            return default_;
        }
        return ret;
    }

    @Nullable
    public <T> T getCapability(BlockCapability<T, @Nullable Direction> capability, Direction to) {
        return this.getCapability(capability, to, to.getOpposite());
    }

    @Nullable
    public <T, C> T getCapability(BlockCapability<T, C> capability, Direction to, C ctx) {
        Object obj;
        Objects.requireNonNull(capability, "Null capability.");
        if (this.level == null || this.pos == null) {
            return null;
        }
        SideCache sideCache = this.cache[CapabilityCache.idxForDir(to)];
        CacheKey key = new CacheKey(capability, ctx);
        CacheValue val = (CacheValue)SneakyUtils.unsafeCast(sideCache.cache.get(key));
        if (val != null) {
            return val.obj;
        }
        BlockPos there = this.pos.relative(to);
        if (this.level.isLoaded(there)) {
            obj = this.level.getCapability(capability, there, ctx);
            sideCache.addListener(there);
        } else {
            obj = null;
        }
        sideCache.cache.put(key, new CacheValue<Object>(obj));
        return (T)obj;
    }

    private static int idxForDir(@Nullable Direction dir) {
        return dir == null ? 6 : dir.ordinal();
    }

    private final class SideCache {
        private final Map<CacheKey, CacheValue<?>> cache = new HashMap();
        @Nullable
        private ICapabilityInvalidationListener listener;

        private SideCache() {
        }

        public void addListener(BlockPos pos) {
            if (this.listener != null) {
                return;
            }
            if (CapabilityCache.this.level == null) {
                throw new RuntimeException("Level is null?? What?");
            }
            this.listener = new ICapabilityInvalidationListener(){
                private final int cookie;
                {
                    this.cookie = CapabilityCache.this.moveCookie;
                }

                public boolean onInvalidate() {
                    if (this.cookie != CapabilityCache.this.moveCookie) {
                        return false;
                    }
                    SideCache.this.cache.clear();
                    return true;
                }
            };
            CapabilityCache.this.level.registerCapabilityListener(pos, this.listener);
        }
    }

    private record CacheKey(BlockCapability<?, ?> capability, @Nullable Object context) {
    }

    private record CacheValue<T>(@Nullable T obj) {
    }
}

