/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.datagen.recipe;

import codechicken.lib.datagen.recipe.AbstractItemStackRecipeBuilder;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.BlastingRecipe;
import net.minecraft.world.item.crafting.CampfireCookingRecipe;
import net.minecraft.world.item.crafting.CookingBookCategory;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.SmeltingRecipe;
import net.minecraft.world.item.crafting.SmokingRecipe;
import net.minecraft.world.level.ItemLike;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public class FurnaceRecipeBuilder
extends AbstractItemStackRecipeBuilder<FurnaceRecipeBuilder> {
    private static final Logger logger = LogManager.getLogger();
    private final Factory factory;
    private CookingBookCategory category = CookingBookCategory.MISC;
    @Nullable
    private Ingredient ingredient;
    private float experience = 0.0f;
    private int cookingTime = 200;

    protected FurnaceRecipeBuilder(ResourceLocation id, ItemStack result, Factory factory) {
        super(id, result);
        this.factory = factory;
    }

    public static FurnaceRecipeBuilder smelting(ItemLike result) {
        return FurnaceRecipeBuilder.smelting(result, 1);
    }

    public static FurnaceRecipeBuilder smelting(ItemLike result, int count) {
        return FurnaceRecipeBuilder.smelting(new ItemStack(result, count));
    }

    public static FurnaceRecipeBuilder smelting(ItemLike result, int count, ResourceLocation id) {
        return FurnaceRecipeBuilder.smelting(new ItemStack(result, count), id);
    }

    public static FurnaceRecipeBuilder smelting(Supplier<? extends ItemLike> result) {
        return FurnaceRecipeBuilder.smelting(result.get(), 1);
    }

    public static FurnaceRecipeBuilder smelting(Supplier<? extends ItemLike> result, int count) {
        return FurnaceRecipeBuilder.smelting(new ItemStack(result.get(), count));
    }

    public static FurnaceRecipeBuilder smelting(Supplier<? extends ItemLike> result, int count, ResourceLocation id) {
        return FurnaceRecipeBuilder.smelting(new ItemStack(result.get(), count), id);
    }

    public static FurnaceRecipeBuilder smelting(ItemStack result) {
        return FurnaceRecipeBuilder.smelting(result, BuiltInRegistries.ITEM.getKey((Object)result.getItem()));
    }

    public static FurnaceRecipeBuilder smelting(ItemStack result, ResourceLocation id) {
        return new FurnaceRecipeBuilder(id, result, SmeltingRecipe::new).cookingTime(200);
    }

    public static FurnaceRecipeBuilder blasting(ItemLike result) {
        return FurnaceRecipeBuilder.blasting(result, 1);
    }

    public static FurnaceRecipeBuilder blasting(ItemLike result, int count) {
        return FurnaceRecipeBuilder.blasting(new ItemStack(result, count));
    }

    public static FurnaceRecipeBuilder blasting(ItemLike result, int count, ResourceLocation id) {
        return FurnaceRecipeBuilder.blasting(new ItemStack(result, count), id);
    }

    public static FurnaceRecipeBuilder blasting(Supplier<? extends ItemLike> result) {
        return FurnaceRecipeBuilder.blasting(result.get(), 1);
    }

    public static FurnaceRecipeBuilder blasting(Supplier<? extends ItemLike> result, int count) {
        return FurnaceRecipeBuilder.blasting(new ItemStack(result.get(), count));
    }

    public static FurnaceRecipeBuilder blasting(Supplier<? extends ItemLike> result, int count, ResourceLocation id) {
        return FurnaceRecipeBuilder.blasting(new ItemStack(result.get(), count), id);
    }

    public static FurnaceRecipeBuilder blasting(ItemStack result) {
        return FurnaceRecipeBuilder.blasting(result, BuiltInRegistries.ITEM.getKey((Object)result.getItem()));
    }

    public static FurnaceRecipeBuilder blasting(ItemStack result, ResourceLocation id) {
        return new FurnaceRecipeBuilder(id, result, BlastingRecipe::new).cookingTime(100);
    }

    public static FurnaceRecipeBuilder smoking(ItemLike result) {
        return FurnaceRecipeBuilder.smoking(result, 1);
    }

    public static FurnaceRecipeBuilder smoking(ItemLike result, int count) {
        return FurnaceRecipeBuilder.smoking(new ItemStack(result, count));
    }

    public static FurnaceRecipeBuilder smoking(ItemLike result, int count, ResourceLocation id) {
        return FurnaceRecipeBuilder.smoking(new ItemStack(result, count), id);
    }

    public static FurnaceRecipeBuilder smoking(Supplier<? extends ItemLike> result) {
        return FurnaceRecipeBuilder.smoking(result.get(), 1);
    }

    public static FurnaceRecipeBuilder smoking(Supplier<? extends ItemLike> result, int count) {
        return FurnaceRecipeBuilder.smoking(new ItemStack(result.get(), count));
    }

    public static FurnaceRecipeBuilder smoking(Supplier<? extends ItemLike> result, int count, ResourceLocation id) {
        return FurnaceRecipeBuilder.smoking(new ItemStack(result.get(), count), id);
    }

    public static FurnaceRecipeBuilder smoking(ItemStack result) {
        return FurnaceRecipeBuilder.smoking(result, BuiltInRegistries.ITEM.getKey((Object)result.getItem()));
    }

    public static FurnaceRecipeBuilder smoking(ItemStack result, ResourceLocation id) {
        return new FurnaceRecipeBuilder(id, result, SmokingRecipe::new).cookingTime(100);
    }

    public static FurnaceRecipeBuilder campfire(ItemLike result) {
        return FurnaceRecipeBuilder.campfire(result, 1);
    }

    public static FurnaceRecipeBuilder campfire(ItemLike result, int count) {
        return FurnaceRecipeBuilder.campfire(new ItemStack(result, count));
    }

    public static FurnaceRecipeBuilder campfire(ItemLike result, int count, ResourceLocation id) {
        return FurnaceRecipeBuilder.campfire(new ItemStack(result, count), id);
    }

    public static FurnaceRecipeBuilder campfire(Supplier<? extends ItemLike> result) {
        return FurnaceRecipeBuilder.campfire(result.get(), 1);
    }

    public static FurnaceRecipeBuilder campfire(Supplier<? extends ItemLike> result, int count) {
        return FurnaceRecipeBuilder.campfire(new ItemStack(result.get(), count));
    }

    public static FurnaceRecipeBuilder campfire(Supplier<? extends ItemLike> result, int count, ResourceLocation id) {
        return FurnaceRecipeBuilder.campfire(new ItemStack(result.get(), count), id);
    }

    public static FurnaceRecipeBuilder campfire(ItemStack result) {
        return FurnaceRecipeBuilder.campfire(result, BuiltInRegistries.ITEM.getKey((Object)result.getItem()));
    }

    public static FurnaceRecipeBuilder campfire(ItemStack result, ResourceLocation id) {
        return new FurnaceRecipeBuilder(id, result, CampfireCookingRecipe::new).cookingTime(600);
    }

    public static FurnaceRecipeBuilder custom(ItemLike result, Factory factory) {
        return FurnaceRecipeBuilder.custom(result, 1, factory);
    }

    public static FurnaceRecipeBuilder custom(ItemLike result, int count, Factory factory) {
        return FurnaceRecipeBuilder.custom(new ItemStack(result, count), factory);
    }

    public static FurnaceRecipeBuilder custom(ItemLike result, int count, ResourceLocation id, Factory factory) {
        return FurnaceRecipeBuilder.custom(new ItemStack(result, count), id, factory);
    }

    public static FurnaceRecipeBuilder custom(Supplier<? extends ItemLike> result, Factory factory) {
        return FurnaceRecipeBuilder.custom(result.get(), 1, factory);
    }

    public static FurnaceRecipeBuilder custom(Supplier<? extends ItemLike> result, int count, Factory factory) {
        return FurnaceRecipeBuilder.custom(new ItemStack(result.get(), count), factory);
    }

    public static FurnaceRecipeBuilder custom(Supplier<? extends ItemLike> result, int count, ResourceLocation id, Factory factory) {
        return FurnaceRecipeBuilder.custom(new ItemStack(result.get(), count), id, factory);
    }

    public static FurnaceRecipeBuilder custom(ItemStack result, Factory factory) {
        return FurnaceRecipeBuilder.custom(result, BuiltInRegistries.ITEM.getKey((Object)result.getItem()), factory);
    }

    public static FurnaceRecipeBuilder custom(ItemStack result, ResourceLocation id, Factory factory) {
        return new FurnaceRecipeBuilder(id, result, factory);
    }

    public FurnaceRecipeBuilder category(CookingBookCategory category) {
        this.category = category;
        return this;
    }

    public FurnaceRecipeBuilder ingredient(TagKey<Item> tag) {
        this.addAutoCriteria(tag);
        this.ingredient = Ingredient.of(tag);
        return this;
    }

    public FurnaceRecipeBuilder ingredient(ItemLike item) {
        this.addAutoCriteria(item);
        this.ingredient = Ingredient.of((ItemLike[])new ItemLike[]{item});
        return this;
    }

    public FurnaceRecipeBuilder ingredient(Supplier<? extends ItemLike> item) {
        this.addAutoCriteria(item.get());
        this.ingredient = Ingredient.of((ItemLike[])new ItemLike[]{item.get()});
        return this;
    }

    public FurnaceRecipeBuilder ingredient(Ingredient ingredient) {
        if (this.generateCriteria) {
            logger.warn("Criteria not automatically generated for raw ingredient.", new Throwable("Here, have a stack trace"));
        }
        this.ingredient = ingredient;
        return this;
    }

    public FurnaceRecipeBuilder experience(float experience) {
        this.experience = experience;
        return this;
    }

    public FurnaceRecipeBuilder cookingTime(int cookingTime) {
        this.cookingTime = cookingTime;
        return this;
    }

    @Override
    public Recipe<?> _build() {
        return this.factory.build(this.group, this.category, Objects.requireNonNull(this.ingredient), (ItemStack)this.result, this.experience, this.cookingTime);
    }

    @Override
    protected void validate() {
        super.validate();
        if (this.ingredient == null) {
            throw new IllegalStateException("No ingredient set.");
        }
    }

    public static interface Factory {
        public Recipe<?> build(String var1, CookingBookCategory var2, Ingredient var3, ItemStack var4, float var5, int var6);
    }
}

