/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.gui.modular.lib;

import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import javax.imageio.ImageIO;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.glfw.GLFW;
import org.lwjgl.glfw.GLFWImage;

public class CursorHelper {
    public static final Logger LOGGER = LogManager.getLogger();
    public static final ResourceLocation DRAG = ResourceLocation.fromNamespaceAndPath((String)"codechickenlib", (String)"textures/gui/cursors/drag.png");
    public static final ResourceLocation RESIZE_H = ResourceLocation.fromNamespaceAndPath((String)"codechickenlib", (String)"textures/gui/cursors/resize_h.png");
    public static final ResourceLocation RESIZE_V = ResourceLocation.fromNamespaceAndPath((String)"codechickenlib", (String)"textures/gui/cursors/resize_v.png");
    public static final ResourceLocation RESIZE_TRBL = ResourceLocation.fromNamespaceAndPath((String)"codechickenlib", (String)"textures/gui/cursors/resize_diag_trbl.png");
    public static final ResourceLocation RESIZE_TLBR = ResourceLocation.fromNamespaceAndPath((String)"codechickenlib", (String)"textures/gui/cursors/resize_diag_tlbr.png");
    private static final Map<ResourceLocation, Long> cursors = new HashMap<ResourceLocation, Long>();
    private static ResourceLocation active = null;

    private static long createCursor(ResourceLocation cursorTexture) {
        try {
            Resource resource = Minecraft.getInstance().getResourceManager().getResource(cursorTexture).orElse(null);
            if (resource == null) {
                return 0L;
            }
            BufferedImage bufferedimage = ImageIO.read(resource.open());
            GLFWImage glfwImage = CursorHelper.imageToGLFWImage(bufferedimage);
            return GLFW.glfwCreateCursor((GLFWImage)glfwImage, (int)16, (int)16);
        }
        catch (Exception e) {
            LOGGER.warn("An error occurred while creating cursor", (Throwable)e);
            return 0L;
        }
    }

    private static GLFWImage imageToGLFWImage(BufferedImage image) {
        if (image.getType() != 3) {
            BufferedImage convertedImage = new BufferedImage(image.getWidth(), image.getHeight(), 3);
            Graphics2D graphics = convertedImage.createGraphics();
            int targetWidth = image.getWidth();
            int targetHeight = image.getHeight();
            graphics.drawImage(image, 0, 0, targetWidth, targetHeight, null);
            graphics.dispose();
            image = convertedImage;
        }
        ByteBuffer buffer = BufferUtils.createByteBuffer((int)(image.getWidth() * image.getHeight() * 4));
        for (int i = 0; i < image.getHeight(); ++i) {
            for (int j = 0; j < image.getWidth(); ++j) {
                int colorSpace = image.getRGB(j, i);
                buffer.put((byte)(colorSpace << 8 >> 24));
                buffer.put((byte)(colorSpace << 16 >> 24));
                buffer.put((byte)(colorSpace << 24 >> 24));
                buffer.put((byte)(colorSpace >> 24));
            }
        }
        buffer.flip();
        GLFWImage result = GLFWImage.create();
        result.set(image.getWidth(), image.getHeight(), buffer);
        return result;
    }

    public static void setCursor(@Nullable ResourceLocation cursor) {
        if (cursor != active) {
            active = cursor;
            long window = Minecraft.getInstance().getWindow().getWindow();
            long newCursor = active == null ? 0L : cursors.computeIfAbsent(cursor, CursorHelper::createCursor);
            GLFW.glfwSetCursor((long)window, (long)newCursor);
        }
    }

    public static void resetCursor() {
        if (active != null) {
            CursorHelper.setCursor(null);
        }
    }

    public static void onResourceReload() {
        cursors.values().forEach(cursor -> {
            if (cursor != 0L) {
                GLFW.glfwDestroyCursor((long)cursor);
            }
        });
        cursors.clear();
    }
}

