/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.inventory;

import codechicken.lib.inventory.InventoryUtils;
import codechicken.lib.util.ArrayUtils;
import java.util.Arrays;
import java.util.Objects;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public class InventorySimple
implements Container {
    public ItemStack[] items;
    public int limit;
    public String name;

    public InventorySimple(ItemStack[] items, int limit, String name) {
        this.items = items;
        ArrayUtils.fillArray(items, ItemStack.EMPTY, Objects::isNull);
        this.limit = limit;
        this.name = name;
    }

    public InventorySimple(ItemStack[] items, String name) {
        this(items, 64, name);
    }

    public InventorySimple(ItemStack[] items, int limit) {
        this(items, limit, "inv");
    }

    public InventorySimple(ItemStack[] items) {
        this(items, 64, "inv");
    }

    public InventorySimple(int size, int limit, String name) {
        this(new ItemStack[size], limit, name);
    }

    public InventorySimple(int size, int limit) {
        this(size, limit, "inv");
    }

    public InventorySimple(int size, String name) {
        this(size, 64, name);
    }

    public InventorySimple(int size) {
        this(size, 64, "inv");
    }

    public int getContainerSize() {
        return this.items.length;
    }

    public boolean isEmpty() {
        return ArrayUtils.count(this.items, stack -> !stack.isEmpty()) <= 0;
    }

    public ItemStack getItem(int slot) {
        return this.items[slot];
    }

    public ItemStack removeItem(int slot, int amount) {
        return InventoryUtils.decrStackSize(this, slot, amount);
    }

    public ItemStack removeItemNoUpdate(int slot) {
        return InventoryUtils.removeStackFromSlot(this, slot);
    }

    public void setItem(int slot, ItemStack stack) {
        this.items[slot] = stack;
        this.setChanged();
    }

    public int getMaxStackSize() {
        return this.limit;
    }

    public boolean stillValid(Player player) {
        return true;
    }

    public void setChanged() {
    }

    public void clearContent() {
        Arrays.fill(this.items, ItemStack.EMPTY);
    }
}

