/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.model.pipeline.transformers;

import codechicken.lib.model.IVertexConsumer;
import codechicken.lib.model.Quad;
import codechicken.lib.model.pipeline.IPipelineElementFactory;
import codechicken.lib.model.pipeline.QuadTransformer;
import codechicken.lib.vec.Cuboid6;
import net.minecraft.core.Direction;
import net.minecraft.world.phys.AABB;

public class QuadFaceStripper
extends QuadTransformer {
    public static final IPipelineElementFactory<QuadFaceStripper> FACTORY = QuadFaceStripper::new;
    private final Cuboid6 bounds = new Cuboid6();
    private int mask;

    QuadFaceStripper() {
    }

    public QuadFaceStripper(IVertexConsumer parent, AABB bounds, int mask) {
        super(parent);
        this.bounds.set(bounds);
        this.mask = mask;
    }

    public void setBounds(Cuboid6 bounds) {
        this.bounds.set(bounds);
    }

    public void setBounds(AABB bounds) {
        this.bounds.set(bounds);
    }

    public void setMask(int mask) {
        this.mask = mask;
    }

    @Override
    public boolean transform() {
        assert (this.quad.orientation != null);
        if (this.mask == 0) {
            return true;
        }
        if ((this.mask & 1 << this.quad.orientation.ordinal()) != 0) {
            Direction.AxisDirection dir = this.quad.orientation.getAxisDirection();
            Quad.Vertex[] vertices = this.quad.vertices;
            switch (this.quad.orientation.getAxis()) {
                case X: {
                    float bound = (float)(dir == Direction.AxisDirection.POSITIVE ? this.bounds.max.x : this.bounds.min.x);
                    float x1 = vertices[0].vec()[0];
                    float x2 = vertices[1].vec()[0];
                    float x3 = vertices[2].vec()[0];
                    float x4 = vertices[3].vec()[0];
                    return x1 != x2 || x2 != x3 || x3 != x4 || x4 != bound;
                }
                case Y: {
                    float bound = (float)(dir == Direction.AxisDirection.POSITIVE ? this.bounds.max.y : this.bounds.min.y);
                    float y1 = vertices[0].vec()[1];
                    float y2 = vertices[1].vec()[1];
                    float y3 = vertices[2].vec()[1];
                    float y4 = vertices[3].vec()[1];
                    return y1 != y2 || y2 != y3 || y3 != y4 || y4 != bound;
                }
                case Z: {
                    float bound = (float)(dir == Direction.AxisDirection.POSITIVE ? this.bounds.max.z : this.bounds.min.z);
                    float z1 = vertices[0].vec()[2];
                    float z2 = vertices[1].vec()[2];
                    float z3 = vertices[2].vec()[2];
                    float z4 = vertices[3].vec()[2];
                    return z1 != z2 || z2 != z3 || z3 != z4 || z4 != bound;
                }
            }
        }
        return true;
    }
}

