/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.raytracer;

import codechicken.lib.vec.Vector3;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class SubHitBlockHitResult
extends BlockHitResult
implements Comparable<SubHitBlockHitResult> {
    public final double dist;
    public final Object hitInfo;
    public final int subHit;

    public SubHitBlockHitResult(Vector3 hitVec, Direction faceIn, BlockPos posIn, boolean isInside, Object data, double dist) {
        this(false, hitVec.vec3(), faceIn, posIn, isInside, data, dist);
    }

    public SubHitBlockHitResult(Vec3 hitVec, Direction faceIn, BlockPos posIn, boolean isInside, Object data, double dist) {
        this(false, hitVec, faceIn, posIn, isInside, data, dist);
    }

    protected SubHitBlockHitResult(boolean isMissIn, Vec3 hitVec, Direction faceIn, BlockPos posIn, boolean isInside, Object data, double dist) {
        super(isMissIn, hitVec, faceIn, posIn, isInside);
        if (data instanceof Integer) {
            Integer d = (Integer)data;
            this.subHit = d;
        } else {
            this.subHit = -1;
        }
        this.hitInfo = data;
        this.dist = dist;
    }

    public SubHitBlockHitResult withDirection(Direction newFace) {
        return new SubHitBlockHitResult(this.getType() == HitResult.Type.MISS, this.getLocation(), this.getDirection(), this.getBlockPos(), this.isInside(), this.hitInfo, this.dist);
    }

    @Override
    public int compareTo(SubHitBlockHitResult o) {
        return Double.compare(this.dist, o.dist);
    }

    public String toString() {
        return super.toString().replace("}", "") + ", subHit=" + this.subHit + ", sqDist: " + this.dist + "}";
    }
}

