/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.render.pipeline.attribute;

import codechicken.lib.colour.ColourRGBA;
import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.pipeline.VertexAttribute;
import codechicken.lib.render.pipeline.attribute.AttributeKey;
import org.jetbrains.annotations.Nullable;

public class LightingAttribute
extends VertexAttribute<int[]> {
    public static final AttributeKey<int[]> attributeKey = AttributeKey.create("lighting", int[]::new);
    private int @Nullable [] colourRef;

    public LightingAttribute() {
        super(attributeKey);
    }

    @Override
    public boolean load(CCRenderState ccrs) {
        assert (ccrs.cFmt != null);
        assert (ccrs.model != null);
        if (!(ccrs.computeLighting && ccrs.cFmt.hasColor && ccrs.model.hasAttribute(attributeKey))) {
            return false;
        }
        this.colourRef = ccrs.model.getAttribute(attributeKey);
        if (this.colourRef != null) {
            ccrs.pipeline.addDependency(ccrs.colourAttrib);
            return true;
        }
        return false;
    }

    @Override
    public void operate(CCRenderState ccrs) {
        assert (this.colourRef != null);
        ccrs.colour = ColourRGBA.multiply(ccrs.colour, this.colourRef[ccrs.vertexIndex]);
    }
}

