/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.util;

import codechicken.lib.vec.Vector3;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class ItemUtils {
    public static boolean isPlayerHolding(LivingEntity entity, Predicate<Item> predicate) {
        for (InteractionHand hand : InteractionHand.values()) {
            ItemStack stack = entity.getItemInHand(hand);
            if (stack.isEmpty() || !predicate.test(stack.getItem())) continue;
            return true;
        }
        return false;
    }

    public static boolean isPlayerHoldingSomething(Player player) {
        return !player.getMainHandItem().isEmpty() || !player.getOffhandItem().isEmpty();
    }

    public static ItemStack getHeldStack(Player player) {
        ItemStack stack = player.getMainHandItem();
        if (stack.isEmpty()) {
            stack = player.getOffhandItem();
        }
        return stack;
    }

    public static void dropItem(ItemStack stack, Level level, Vector3 dropLocation) {
        ItemEntity item = new ItemEntity(level, dropLocation.x, dropLocation.y, dropLocation.z, stack);
        item.setDeltaMovement(level.random.nextGaussian() * 0.05, level.random.nextGaussian() * 0.05 + (double)0.2f, level.random.nextGaussian() * 0.05);
        level.addFreshEntity((Entity)item);
    }

    public static void dropItem(Level world, BlockPos pos, ItemStack stack, double velocity) {
        double xVelocity = (double)world.random.nextFloat() * velocity + (1.0 - velocity) * 0.5;
        double yVelocity = (double)world.random.nextFloat() * velocity + (1.0 - velocity) * 0.5;
        double zVelocity = (double)world.random.nextFloat() * velocity + (1.0 - velocity) * 0.5;
        ItemEntity entityItem = new ItemEntity(world, (double)pos.getX() + xVelocity, (double)pos.getY() + yVelocity, (double)pos.getZ() + zVelocity, stack);
        entityItem.setPickUpDelay(10);
        world.addFreshEntity((Entity)entityItem);
    }

    public static void dropItem(Level world, BlockPos pos, ItemStack stack) {
        ItemUtils.dropItem(world, pos, stack, 0.7);
    }

    public static void dropInventory(Level world, BlockPos pos, Container inventory) {
        for (int i = 0; i < inventory.getContainerSize(); ++i) {
            ItemStack stack = inventory.getItem(i);
            if (stack.isEmpty() || stack.getCount() <= 0) continue;
            ItemUtils.dropItem(world, pos, stack);
        }
    }

    public static ItemStack copyStack(ItemStack stack, int quantity) {
        if (stack.isEmpty()) {
            return ItemStack.EMPTY;
        }
        stack = stack.copy();
        stack.setCount(quantity);
        return stack;
    }

    public static void ejectItem(Level world, BlockPos pos, ItemStack stack, Direction dir) {
        pos.relative(dir);
        ItemEntity entity = new ItemEntity(world, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, stack);
        entity.setDeltaMovement(Vec3.atLowerCornerOf((Vec3i)dir.getNormal()).scale(0.3));
        entity.setPickUpDelay(10);
        world.addFreshEntity((Entity)entity);
    }

    public static void ejectItems(Level world, BlockPos pos, List<ItemStack> stacks, Direction dir) {
        for (ItemStack stack : stacks) {
            ItemUtils.ejectItem(world, pos, stack, dir);
        }
    }

    public static int compareItemStack(ItemStack stack1, ItemStack stack2) {
        int itemStack2ID;
        int itemStack1ID = Item.getId((Item)stack1.getItem());
        return itemStack1ID != (itemStack2ID = Item.getId((Item)stack2.getItem())) ? itemStack1ID - itemStack2ID : (stack1.getDamageValue() == stack2.getDamageValue() ? 0 : stack1.getDamageValue() - stack2.getDamageValue());
    }

    public static boolean areStacksSameType(ItemStack stack1, ItemStack stack2) {
        return !stack1.isEmpty() && !stack2.isEmpty() && stack1.getItem() == stack2.getItem() && stack2.getDamageValue() == stack1.getDamageValue() && ItemStack.isSameItemSameComponents((ItemStack)stack2, (ItemStack)stack1);
    }
}

