/*
 * Decompiled with CFR 0.152.
 */
package com.traverse.bhc.common.items;

import com.traverse.bhc.common.items.BaseItem;
import com.traverse.bhc.common.util.HeartType;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;

public class ItemHeart
extends BaseItem {
    protected final HeartType type;

    public ItemHeart(HeartType type) {
        this.type = type;
    }

    public UseAnim getUseAnimation(ItemStack stack) {
        return UseAnim.EAT;
    }

    public int getUseDuration(ItemStack stack, LivingEntity entity) {
        return 30;
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player playerIn, InteractionHand hand) {
        playerIn.startUsingItem(hand);
        return InteractionResultHolder.sidedSuccess((Object)playerIn.getItemInHand(hand), (boolean)level.isClientSide());
    }

    public ItemStack finishUsingItem(ItemStack stack, Level worldIn, LivingEntity entityLiving) {
        if (!worldIn.isClientSide()) {
            Player player;
            entityLiving.heal((float)this.type.healAmount);
            if (!(entityLiving instanceof Player) || !(player = (Player)entityLiving).isCreative()) {
                stack.shrink(1);
            }
            if (entityLiving instanceof ServerPlayer) {
                player = (ServerPlayer)entityLiving;
                player.resetSentInfo();
            }
        }
        return stack;
    }
}

