/*
 * Decompiled with CFR 0.152.
 */
package com.traverse.bhc.common.items.tools;

import com.traverse.bhc.common.BaubleyHeartCanisters;
import com.traverse.bhc.common.config.ConfigHandler;
import com.traverse.bhc.common.container.BladeOfVitalityContainer;
import com.traverse.bhc.common.init.RegistryHandler;
import com.traverse.bhc.common.util.HealthModifier;
import com.traverse.bhc.common.util.InventoryUtil;
import com.traverse.bhc.common.util.SoulContainerProvider;
import java.util.List;
import java.util.stream.IntStream;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.Unbreakable;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.ItemAttributeModifierEvent;
import net.neoforged.neoforge.items.ComponentItemHandler;

@EventBusSubscriber(modid="bhc", bus=EventBusSubscriber.Bus.GAME)
public class ItemBladeOfVitality
extends SwordItem
implements SoulContainerProvider {
    private static final double EXTRA_DAMAGE_PER_HEART = 1.0;
    public static final ResourceLocation DAMAGE_MODIFIER_ID = BaubleyHeartCanisters.id("blade_of_vitality");

    public ItemBladeOfVitality() {
        super((Tier)Tiers.NETHERITE, new Item.Properties().attributes(ItemBladeOfVitality.createAttributes((Tier)Tiers.NETHERITE, (int)3, (float)-2.4f)).component(DataComponents.UNBREAKABLE, (Object)new Unbreakable(false)));
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        if (player.isShiftKeyDown()) {
            if (!level.isClientSide()) {
                this.openMenu(player, hand, BladeOfVitalityContainer::new);
            }
            return InteractionResultHolder.sidedSuccess((Object)player.getItemInHand(hand), (boolean)level.isClientSide());
        }
        return super.use(level, player, hand);
    }

    public boolean isRepairable(ItemStack stack) {
        return false;
    }

    public boolean isDamageable(ItemStack stack) {
        return false;
    }

    @SubscribeEvent
    public static void onAttributeModifiers(ItemAttributeModifierEvent event) {
        if (event.getItemStack().is(RegistryHandler.BLADE_OF_VITALITY)) {
            event.removeModifier(Attributes.ATTACK_DAMAGE, DAMAGE_MODIFIER_ID);
            int heartCount = HealthModifier.getHeartCount(event.getItemStack());
            if (heartCount > 0) {
                event.addModifier(Attributes.ATTACK_DAMAGE, new AttributeModifier(DAMAGE_MODIFIER_ID, (double)heartCount * 1.0, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND);
            }
        }
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
        tooltipComponents.add((Component)Component.translatable((String)Util.makeDescriptionId((String)"tooltip", (ResourceLocation)RegistryHandler.BLADE_OF_VITALITY.getId())).setStyle(Style.EMPTY.applyFormat(ChatFormatting.GOLD)));
        if (Screen.hasShiftDown()) {
            int[] heartCount = new int[]{HealthModifier.getHeartCount(stack)};
            int heartTotal = IntStream.of(heartCount).sum();
            tooltipComponents.add((Component)Component.translatable((String)Util.makeDescriptionId((String)"tooltip", (ResourceLocation)BaubleyHeartCanisters.id("heart_amount")), (Object[])new Object[]{heartTotal}).setStyle(Style.EMPTY.applyFormat(ChatFormatting.DARK_RED)));
        }
    }

    public boolean supportsEnchantment(ItemStack stack, Holder<Enchantment> enchantment) {
        return true;
    }

    @Override
    public Component getContainerName(ItemStack stack) {
        return Component.translatable((String)"container.bhc.blade_of_vitality");
    }

    private static int getMaxHearts(ItemStack stack) {
        ComponentItemHandler inv = InventoryUtil.createVirtualInventory(4, stack);
        int total = 0;
        for (int i = 0; i < inv.getSlots(); ++i) {
            ItemStack invStack = inv.getStackInSlot(i);
            total += !invStack.isEmpty() ? invStack.getMaxStackSize() : ((Integer)ConfigHandler.general.heartStackSize.get()).intValue();
        }
        return total;
    }
}

