/*
 * Decompiled with CFR 0.152.
 */
package com.folumo.mekanism_lasers.common.block_entity;

import com.folumo.mekanism_lasers.common.registry.BlockRegistry;
import java.util.function.Predicate;
import mekanism.api.IContentsListener;
import mekanism.api.RelativeSide;
import mekanism.api.energy.IEnergyContainer;
import mekanism.common.capabilities.energy.BasicEnergyContainer;
import mekanism.common.capabilities.energy.LaserEnergyContainer;
import mekanism.common.capabilities.holder.energy.EnergyContainerHelper;
import mekanism.common.tile.base.TileEntityMekanism;
import mekanism.common.tile.laser.TileEntityLaserReceptor;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

public class LaserSplitterLBlockEntity
extends TileEntityLaserReceptor {
    private long fireNext;

    public LaserSplitterLBlockEntity(BlockPos pos, BlockState state) {
        super(BlockRegistry.LASER_SPLITTER, pos, state);
    }

    protected void addInitialEnergyContainers(EnergyContainerHelper builder, IContentsListener listener) {
        this.energyContainer = LaserEnergyContainer.create((Predicate)BasicEnergyContainer.notExternal, (Predicate)BasicEnergyContainer.internalOnly, (TileEntityMekanism)this, (IContentsListener)listener);
        builder.addContainer((IEnergyContainer)this.energyContainer, new RelativeSide[]{RelativeSide.BACK});
    }

    @NotNull
    public Component getName() {
        return Component.literal((String)"Laser Splitter");
    }

    public static long getMaxEnergy() {
        return 10000000000L;
    }

    protected long toFire() {
        if (this.fireNext == 0L) {
            this.fireNext = this.energyContainer.getEnergy() / 2L;
            return this.fireNext;
        }
        long toBeFired = this.fireNext;
        this.fireNext = 0L;
        return toBeFired;
    }

    protected boolean onUpdateServer() {
        boolean sendUpdatePacket = super.onUpdateServer();
        Direction direction = this.getDirection();
        this.setFacing(direction.getOpposite());
        return sendUpdatePacket;
    }
}

