/*
 * Decompiled with CFR 0.152.
 */
package dev.wp.mekanism_unleashed;

import net.neoforged.neoforge.common.ModConfigSpec;

public class MekanismUnleashedConfig {
    private static final ModConfigSpec.Builder BUILDER = new ModConfigSpec.Builder();
    private static final ModConfigSpec.IntValue MAX_UPGRADES;
    private static final ModConfigSpec.BooleanValue ENCHANTABLE_MEKA_GEAR;
    public static final ModConfigSpec SPEC;
    public static int maxUpgrades;
    public static boolean enchantableMekaGear;

    private static String key(String key) {
        return "mekanism_unleashed.config." + key;
    }

    public static void loadConfig() {
        maxUpgrades = (Integer)MAX_UPGRADES.get();
        enchantableMekaGear = (Boolean)ENCHANTABLE_MEKA_GEAR.get();
    }

    static {
        BUILDER.translation(MekanismUnleashedConfig.key("tweaks")).push("Tweaks");
        MAX_UPGRADES = BUILDER.translation(MekanismUnleashedConfig.key("maxUpgrades")).comment("Maximum speed/energy upgrades a machine can accept, values higher than 32 are not recommended").defineInRange("maxUpgrades", 32, 8, Integer.MAX_VALUE);
        ENCHANTABLE_MEKA_GEAR = BUILDER.translation(MekanismUnleashedConfig.key("enchantableMekaGear")).comment(new String[]{"Allow Meka Armor/Tool to be enchanted", "Note: You will need to add the items to the enchantable tags yourself, this mod does not do that for you"}).define("enchantableMekaGear", false);
        BUILDER.pop();
        SPEC = BUILDER.build();
    }
}

