/*
 * Decompiled with CFR 0.152.
 */
package de.cech12.woodenbucket.platform;

import de.cech12.woodenbucket.platform.services.IConfigHelper;
import net.neoforged.fml.ModLoadingContext;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.neoforge.common.ModConfigSpec;

public class NeoForgeConfigHelper
implements IConfigHelper {
    private static final ModConfigSpec SERVER_CONFIG;
    private static final ModConfigSpec.IntValue BREAK_TEMPERATURE;
    private static final ModConfigSpec.IntValue BURNING_TEMPERATURE;
    private static final ModConfigSpec.IntValue DURABILITY;
    private static final ModConfigSpec.BooleanValue FISH_OBTAINING_ENABLED;
    private static final ModConfigSpec.IntValue FREEZING_TEMPERATURE;
    private static final ModConfigSpec.BooleanValue MILKING_ENABLED;

    @Override
    public void init() {
        ModLoadingContext.get().getActiveContainer().registerConfig(ModConfig.Type.SERVER, (IConfigSpec)SERVER_CONFIG);
    }

    @Override
    public int getBreakTemperature() {
        try {
            return (Integer)BREAK_TEMPERATURE.get();
        }
        catch (IllegalStateException ex) {
            return 1000;
        }
    }

    @Override
    public int getBurningTemperature() {
        try {
            return (Integer)BURNING_TEMPERATURE.get();
        }
        catch (IllegalStateException ex) {
            return 1000;
        }
    }

    @Override
    public int getDurability() {
        try {
            return (Integer)DURABILITY.get();
        }
        catch (IllegalStateException ex) {
            return 25;
        }
    }

    @Override
    public boolean isFishObtainingEnabled() {
        try {
            return (Boolean)FISH_OBTAINING_ENABLED.get();
        }
        catch (IllegalStateException ex) {
            return true;
        }
    }

    @Override
    public int getFreezingTemperature() {
        try {
            return (Integer)FREEZING_TEMPERATURE.get();
        }
        catch (IllegalStateException ex) {
            return -1;
        }
    }

    @Override
    public boolean isMilkingEnabled() {
        try {
            return (Boolean)MILKING_ENABLED.get();
        }
        catch (IllegalStateException ex) {
            return true;
        }
    }

    static {
        ModConfigSpec.Builder builder = new ModConfigSpec.Builder();
        builder.push("Balance Options");
        BREAK_TEMPERATURE = builder.comment("Minimum temperature of fluid at which the Wooden Bucket breaks when emptied. (default: 1000) (Deactivation by setting a number larger than the hottest fluid)").defineInRange("crackingTemperature", 1000, -10000, 10000);
        BURNING_TEMPERATURE = builder.comment("Fluid temperature from which you get a burning effect if a Wooden Bucket contains such a hot fluid. (default: 1000) (Deactivation by setting a number larger than the hottest fluid)").defineInRange("burningTemperature", 1000, -10000, 10000);
        DURABILITY = builder.comment("Defines the maximum durability of Wooden Bucket. (default: 25, 0: deactivates the durability)").defineInRange("durability", 25, 0, 10000);
        FISH_OBTAINING_ENABLED = builder.comment("Whether or not obtaining fish with a Wooden Bucket should be enabled. (default: true)").define("fishObtainingEnabled", true);
        FREEZING_TEMPERATURE = builder.comment("Fluid temperature from which you get a freezing effect if a Wooden Bucket contains this fluid. (default: -1) (Deactivation by setting a number lower than the coldest fluid)").defineInRange("freezingTemperature", -1, -10000, 10000);
        MILKING_ENABLED = builder.comment("Whether or not milking entities with a Wooden Bucket should be enabled. (default: true)").define("milkingEnabled", true);
        builder.pop();
        SERVER_CONFIG = builder.build();
    }
}

