/*
 * Decompiled with CFR 0.152.
 */
package de.cech12.bucketlib.api.item;

import de.cech12.bucketlib.api.BucketLib;
import de.cech12.bucketlib.platform.Services;
import de.cech12.bucketlib.util.BucketLibUtil;
import de.cech12.bucketlib.util.ItemStackUtil;
import de.cech12.bucketlib.util.RegistryUtil;
import de.cech12.bucketlib.util.WorldInteractionUtil;
import java.util.Arrays;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stats;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.FastColor;
import net.minecraft.util.Tuple;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.animal.Bucketable;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.MilkBucketItem;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;

public class UniversalBucketItem
extends Item {
    private final Properties properties;

    public UniversalBucketItem(Properties properties) {
        super(new Item.Properties().stacksTo(1));
        this.properties = properties;
    }

    @Nonnull
    public Component getName(@Nonnull ItemStack stack) {
        Component argument;
        Object descriptionId = this.getDescriptionId(stack);
        if (BucketLibUtil.containsEntityType(stack)) {
            descriptionId = (String)descriptionId + ".entity";
            EntityType<?> entityType = BucketLibUtil.getEntityType(stack);
            argument = entityType != null ? entityType.getDescription() : Component.literal((String)"?");
        } else if (BucketLibUtil.containsFluid(stack)) {
            descriptionId = (String)descriptionId + ".filled";
            Fluid fluid = BucketLibUtil.getFluid(stack);
            argument = Services.FLUID.getFluidDescription(fluid);
        } else if (BucketLibUtil.containsBlock(stack)) {
            descriptionId = (String)descriptionId + ".filled";
            Block block = BucketLibUtil.getBlock(stack);
            argument = block != null ? block.getName() : Component.literal((String)"?");
        } else if (BucketLibUtil.containsMilk(stack)) {
            descriptionId = (String)descriptionId + ".filled";
            argument = Component.translatable((String)Services.PLATFORM.getMilkTranslationKey());
        } else {
            return Component.translatable((String)descriptionId);
        }
        return Component.translatable((String)descriptionId, (Object[])new Object[]{argument});
    }

    public boolean isCracked(ItemStack stack) {
        Fluid fluid = BucketLibUtil.getFluid(stack);
        if (fluid != Fluids.EMPTY) {
            int fluidTemperature = Services.FLUID.getFluidTemperature(fluid);
            Integer upperCrackingTemperature = this.getUpperBreakTemperature();
            Integer lowerCrackingTemperature = this.getLowerBreakTemperature();
            return this.isCrackingFluid(fluid) || upperCrackingTemperature != null && fluidTemperature >= upperCrackingTemperature || lowerCrackingTemperature != null && fluidTemperature <= lowerCrackingTemperature && !BucketLibUtil.isAffectedByInfinityEnchantment(stack);
        }
        return false;
    }

    public boolean canHoldFluid(Fluid fluid) {
        Item bucket;
        if (fluid == Fluids.EMPTY) {
            return true;
        }
        try {
            bucket = fluid.getBucket();
        }
        catch (IllegalArgumentException ex) {
            BucketLib.LOG.error("IllegalArgumentException occurred while trying to get the bucket item of fluid '" + String.valueOf(Services.FLUID.getFluidDescription(fluid)) + "' [fluid.getBucket()]. BucketLib is not compatible with this fluid. Please contact the mod developer of the mod which adds this fluid!", (Throwable)ex);
            return false;
        }
        if (bucket instanceof MilkBucketItem && fluid != Services.FLUID.getMilkFluid()) {
            return false;
        }
        if (!(bucket instanceof MilkBucketItem || bucket instanceof BucketItem && Services.BUCKET.getFluidOfBucketItem((BucketItem)bucket) == fluid)) {
            return false;
        }
        if (this.properties.allowedFluidsTag != null || this.properties.allowedFluids != null) {
            return this.isAllowedFluid(fluid);
        }
        if (this.properties.deniedFluidsTag != null || this.properties.deniedFluids != null) {
            return !this.isDeniedFluid(fluid);
        }
        int fluidTemperature = Services.FLUID.getFluidTemperature(fluid);
        Integer maxTemperature = this.getMaxTemperature();
        Integer minTemperature = this.getMinTemperature();
        return !(maxTemperature != null && fluidTemperature > maxTemperature || minTemperature != null && fluidTemperature < minTemperature);
    }

    public boolean canHoldEntity(EntityType<?> entityType) {
        if (this.canObtainEntities()) {
            if (this.properties.allowedEntitiesTag != null || this.properties.allowedEntities != null) {
                return this.isAllowedEntity(entityType);
            }
            if (this.properties.deniedEntitiesTag != null || this.properties.deniedEntities != null) {
                return !this.isDeniedEntity(entityType);
            }
            return true;
        }
        return false;
    }

    public boolean canHoldBlock(Block block) {
        if (this.canObtainBlocks()) {
            if (this.properties.allowedBlocksTag != null || this.properties.allowedBlocks != null) {
                return this.isAllowedBlock(block);
            }
            if (this.properties.deniedBlocksTag != null || this.properties.deniedBlocks != null) {
                return !this.isDeniedBlock(block);
            }
            return true;
        }
        return false;
    }

    public int getMaxStackSize(ItemStack stack) {
        return BucketLibUtil.isEmpty(stack) ? this.properties.maxStackSize : 1;
    }

    public int getBucketBurnTime(ItemStack stack, RecipeType<?> recipeType) {
        Fluid fluid;
        if (stack.getItem() instanceof UniversalBucketItem && !BucketLibUtil.containsEntityType(stack) && (fluid = Services.FLUID.getContainedFluid(stack)) != Fluids.EMPTY) {
            return Services.PLATFORM.getBurnTime(new ItemStack((ItemLike)fluid.getBucket()), recipeType);
        }
        return 0;
    }

    public void inventoryTick(@Nonnull ItemStack itemStack, @Nonnull Level level, @Nonnull Entity entity, int position, boolean selected) {
        if (!level.isClientSide) {
            if (!entity.fireImmune() && this.hasBurningContent(itemStack)) {
                entity.setTicksFrozen(0);
                entity.setRemainingFireTicks(100);
                if (BucketLibUtil.notCreative(entity) && entity.tickCount % 20 == 0) {
                    BucketLibUtil.damageByOne(itemStack, (ServerLevel)level, entity instanceof Player ? (Player)entity : null);
                }
            } else if (!entity.isOnFire() && entity.canFreeze() && this.hasFreezingContent(itemStack)) {
                int ticks = entity.getTicksFrozen() + (entity.isInPowderSnow ? 1 : 3);
                entity.setTicksFrozen(Math.min(entity.getTicksRequiredToFreeze(), ticks));
                if (BucketLibUtil.notCreative(entity) && entity.tickCount % 40 == 0 && entity.isFullyFrozen()) {
                    entity.hurt(level.damageSources().freeze(), entity.getType().is(EntityTypeTags.FREEZE_HURTS_EXTRA_TYPES) ? 5.0f : 1.0f);
                    BucketLibUtil.damageByOne(itemStack, (ServerLevel)level, entity instanceof Player ? (Player)entity : null);
                }
            }
        }
    }

    private boolean hasBurningContent(@Nonnull ItemStack itemStack) {
        Integer burningTemperature = this.getBurningTemperature();
        Fluid fluid = BucketLibUtil.getFluid(itemStack);
        return fluid != Fluids.EMPTY && (burningTemperature != null && Services.FLUID.getFluidTemperature(fluid) >= burningTemperature || this.isBurningFluid(fluid)) || this.isBurningBlock(BucketLibUtil.getBlock(itemStack));
    }

    private boolean hasFreezingContent(@Nonnull ItemStack itemStack) {
        Integer freezingTemperature = this.getFreezingTemperature();
        Fluid fluid = BucketLibUtil.getFluid(itemStack);
        return fluid != Fluids.EMPTY && (freezingTemperature != null && Services.FLUID.getFluidTemperature(fluid) <= freezingTemperature || this.isFreezingFluid(fluid)) || this.isFreezingBlock(BucketLibUtil.getBlock(itemStack));
    }

    @Nonnull
    public InteractionResultHolder<ItemStack> use(@Nonnull Level level, @Nonnull Player player, @Nonnull InteractionHand interactionHand) {
        ItemStack itemstack = player.getItemInHand(interactionHand);
        boolean isEmpty = BucketLibUtil.isEmpty(itemstack);
        BlockHitResult blockHitResult = UniversalBucketItem.getPlayerPOVHitResult((Level)level, (Player)player, (ClipContext.Fluid)(isEmpty ? ClipContext.Fluid.SOURCE_ONLY : ClipContext.Fluid.NONE));
        if (blockHitResult.getType() == HitResult.Type.BLOCK) {
            ServerLevel serverLevel;
            BlockPos hitBlockPos = blockHitResult.getBlockPos();
            BlockState hitBlockState = level.getBlockState(hitBlockPos);
            Direction hitDirection = blockHitResult.getDirection();
            BlockPos relativeBlockPos = hitBlockPos.relative(hitDirection);
            ServerLevel serverLevel2 = serverLevel = level instanceof ServerLevel ? (ServerLevel)level : null;
            if (isEmpty) {
                InteractionResultHolder<ItemStack> caldronInteractionResult = WorldInteractionUtil.tryPickupFromCauldron(level, player, interactionHand, blockHitResult);
                if (caldronInteractionResult.getResult().consumesAction()) {
                    return caldronInteractionResult;
                }
                Tuple<Boolean, ItemStack> result = Services.FLUID.tryPickUpFluid(BucketLibUtil.removeEntityType(itemstack, serverLevel, player, false), player, level, interactionHand, hitBlockPos, hitDirection);
                if (((Boolean)result.getA()).booleanValue()) {
                    return InteractionResultHolder.sidedSuccess((Object)ItemUtils.createFilledResult((ItemStack)itemstack, (Player)player, (ItemStack)((ItemStack)result.getB())), (boolean)level.isClientSide());
                }
                RegistryUtil.BucketBlock bucketBlock = RegistryUtil.getBucketBlock(hitBlockState.getBlock());
                if (bucketBlock != null && this.canHoldBlock(bucketBlock.block())) {
                    ItemStack fakeStack = new ItemStack((ItemLike)Items.BUCKET);
                    player.setItemInHand(interactionHand, fakeStack);
                    InteractionResultHolder interactionResult = fakeStack.use(level, player, interactionHand);
                    player.setItemInHand(interactionHand, itemstack);
                    if (interactionResult.getResult().consumesAction()) {
                        return new InteractionResultHolder(interactionResult.getResult(), (Object)ItemUtils.createFilledResult((ItemStack)itemstack.copy(), (Player)player, (ItemStack)BucketLibUtil.addBlock(ItemStackUtil.copyStackWithSize(itemstack, 1), bucketBlock.block())));
                    }
                }
            } else {
                InteractionResultHolder<ItemStack> caldronInteractionResult = WorldInteractionUtil.tryPlaceIntoCauldron(level, player, interactionHand, blockHitResult);
                if (caldronInteractionResult.getResult().consumesAction()) {
                    return caldronInteractionResult;
                }
                if (BucketLibUtil.containsFluid(itemstack)) {
                    for (BlockPos pos : Arrays.asList(hitBlockPos, relativeBlockPos)) {
                        Tuple<Boolean, ItemStack> result = Services.FLUID.tryPlaceFluid(BucketLibUtil.removeEntityType(itemstack, serverLevel, player, false), player, level, interactionHand, pos);
                        if (!((Boolean)result.getA()).booleanValue()) continue;
                        if (BucketLibUtil.containsEntityType(itemstack)) {
                            this.spawnEntityFromBucket(player, level, itemstack, pos, false);
                        }
                        return InteractionResultHolder.sidedSuccess((Object)BucketLibUtil.createEmptyResult(itemstack, player, (ItemStack)result.getB(), interactionHand), (boolean)level.isClientSide());
                    }
                } else {
                    if (BucketLibUtil.containsEntityType(itemstack)) {
                        ItemStack emptyBucket = this.spawnEntityFromBucket(player, level, itemstack, relativeBlockPos, true);
                        return InteractionResultHolder.sidedSuccess((Object)BucketLibUtil.createEmptyResult(itemstack, player, emptyBucket, interactionHand), (boolean)level.isClientSide());
                    }
                    if (BucketLibUtil.containsBlock(itemstack)) {
                        Block block = BucketLibUtil.getBlock(itemstack);
                        RegistryUtil.BucketBlock bucketBlock = RegistryUtil.getBucketBlock(block);
                        if (block != null && bucketBlock != null) {
                            ItemStack fakeStack = new ItemStack((ItemLike)bucketBlock.bucketItem());
                            player.setItemInHand(interactionHand, fakeStack);
                            InteractionResult interactionResult = fakeStack.useOn(new UseOnContext(player, interactionHand, blockHitResult));
                            player.setItemInHand(interactionHand, itemstack);
                            if (interactionResult.consumesAction()) {
                                return new InteractionResultHolder(interactionResult, (Object)BucketLibUtil.createEmptyResult(itemstack, player, BucketLibUtil.removeBlock(itemstack, serverLevel, player, true), interactionHand));
                            }
                        }
                    }
                }
            }
        }
        if (BucketLibUtil.containsMilk(itemstack)) {
            return ItemUtils.startUsingInstantly((Level)level, (Player)player, (InteractionHand)interactionHand);
        }
        return InteractionResultHolder.pass((Object)itemstack);
    }

    public ItemStack spawnEntityFromBucket(@Nullable Player player, Level level, ItemStack itemStack, BlockPos pos, boolean damage) {
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            EntityType<?> entityType = BucketLibUtil.getEntityType(itemStack);
            if (entityType != null) {
                Entity entity = entityType.spawn(serverLevel, itemStack, null, pos, MobSpawnType.BUCKET, true, false);
                if (entity instanceof Bucketable) {
                    Bucketable bucketable = (Bucketable)entity;
                    CustomData customdata = (CustomData)itemStack.getOrDefault(DataComponents.BUCKET_ENTITY_DATA, (Object)CustomData.EMPTY);
                    bucketable.loadFromBucketTag(customdata.copyTag());
                    bucketable.setFromBucket(true);
                }
                if (player != null) {
                    serverLevel.gameEvent((Entity)player, (Holder)GameEvent.ENTITY_PLACE, pos);
                }
                return BucketLibUtil.removeEntityType(itemStack, serverLevel, player, damage);
            }
        }
        return itemStack.copy();
    }

    @Nonnull
    public InteractionResult interactLivingEntity(@Nonnull ItemStack itemStack, @Nonnull Player player, @Nonnull LivingEntity entity, @Nonnull InteractionHand interactionHand) {
        InteractionResult result;
        if (entity instanceof Bucketable && !BucketLibUtil.containsEntityType(itemStack) && this.canHoldEntity(entity.getType()) && (result = this.pickupEntityWithBucket(player, interactionHand, (LivingEntity)((Bucketable)entity))).consumesAction()) {
            return result;
        }
        if (this.canMilkEntities() && BucketLibUtil.isEmpty(itemStack)) {
            return WorldInteractionUtil.tryMilkLivingEntity(itemStack, entity, player, interactionHand);
        }
        return super.interactLivingEntity(itemStack, player, entity, interactionHand);
    }

    private <T extends LivingEntity> InteractionResult pickupEntityWithBucket(Player player, InteractionHand interactionHand, T entity) {
        ItemStack itemStack = player.getItemInHand(interactionHand).copy();
        Fluid containedFluid = Services.FLUID.getContainedFluid(itemStack);
        Fluid entityBucketFluid = Services.BUCKET.getFluidOfBucketItem((BucketItem)((Bucketable)entity).getBucketItemStack().getItem());
        if (itemStack.getItem() instanceof UniversalBucketItem && entity.isAlive() && entityBucketFluid == containedFluid) {
            entity.playSound(((Bucketable)entity).getPickupSound(), 1.0f, 1.0f);
            ItemStack filledItemStack = BucketLibUtil.addEntityType(itemStack, entity.getType());
            ((Bucketable)entity).saveToBucketTag(filledItemStack);
            Level level = entity.level();
            ItemStack handItemStack = ItemUtils.createFilledResult((ItemStack)itemStack, (Player)player, (ItemStack)filledItemStack, (boolean)false);
            player.setItemInHand(interactionHand, handItemStack);
            if (!level.isClientSide) {
                CriteriaTriggers.FILLED_BUCKET.trigger((ServerPlayer)player, new ItemStack((ItemLike)((Bucketable)entity).getBucketItemStack().getItem()));
            }
            entity.discard();
            return InteractionResult.sidedSuccess((boolean)level.isClientSide);
        }
        return InteractionResult.PASS;
    }

    @Nonnull
    public ItemStack finishUsingItem(@Nonnull ItemStack itemStack, @Nonnull Level level, @Nonnull LivingEntity player) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            CriteriaTriggers.CONSUME_ITEM.trigger(serverPlayer, new ItemStack((ItemLike)Items.MILK_BUCKET));
            serverPlayer.awardStat(Stats.ITEM_USED.get((Object)Items.MILK_BUCKET));
        }
        if (!level.isClientSide) {
            Services.FLUID.curePotionEffects(player, new ItemStack((ItemLike)Items.MILK_BUCKET));
            if (BucketLibUtil.notCreative((Entity)player)) {
                return BucketLibUtil.removeMilk(itemStack, (ServerLevel)level, player instanceof Player ? (Player)player : null);
            }
        }
        return itemStack;
    }

    public int getUseDuration(@Nonnull ItemStack itemStack, @Nonnull LivingEntity livingEntity) {
        if (BucketLibUtil.containsMilk(itemStack)) {
            return 32;
        }
        return super.getUseDuration(itemStack, livingEntity);
    }

    @Nonnull
    public UseAnim getUseAnimation(@Nonnull ItemStack itemStack) {
        if (BucketLibUtil.containsMilk(itemStack)) {
            return UseAnim.DRINK;
        }
        return super.getUseAnimation(itemStack);
    }

    public boolean hasCraftingRemainingItem(ItemStack stack) {
        return !BucketLibUtil.isEmpty(stack) && !this.isCracked(stack);
    }

    public ItemStack getCraftingRemainingItem(ItemStack itemStack) {
        if (!this.hasCraftingRemainingItem(itemStack)) {
            return ItemStack.EMPTY;
        }
        if (BucketLibUtil.isAffectedByInfinityEnchantment(itemStack)) {
            return itemStack.copy();
        }
        ItemStack result = itemStack.copy();
        boolean damaged = BucketLibUtil.containsFluid(result);
        if (BucketLibUtil.containsBlock(result)) {
            result = BucketLibUtil.removeBlock(result, null, null, !damaged);
            damaged = true;
        }
        if (BucketLibUtil.containsEntityType(result)) {
            result = BucketLibUtil.removeEntityType(result, null, null, !damaged);
        }
        if (BucketLibUtil.containsFluid(result) || BucketLibUtil.containsMilk(result)) {
            result = BucketLibUtil.removeFluid(result, null, null);
        }
        return result;
    }

    public ItemStack getRecipeRemainder(ItemStack itemStack) {
        return this.getCraftingRemainingItem(itemStack);
    }

    private boolean getBooleanProperty(Supplier<Boolean> config, boolean defaultValue) {
        if (config != null) {
            return config.get();
        }
        return defaultValue;
    }

    private Integer getIntProperty(Supplier<Integer> config, Integer defaultValue) {
        if (config != null) {
            return config.get();
        }
        return defaultValue;
    }

    private <T> boolean isElementListedInProperty(T element, TagKey<T> tag, List<T> defaultList) {
        if (tag != null) {
            if (element instanceof Block) {
                Block block = (Block)element;
                return block.defaultBlockState().is(tag);
            }
            if (element instanceof Fluid) {
                Fluid fluid = (Fluid)element;
                return fluid.defaultFluidState().is(tag);
            }
            if (element instanceof EntityType) {
                EntityType entityType = (EntityType)element;
                return entityType.is(tag);
            }
        }
        return defaultList != null && defaultList.contains(element);
    }

    public ResourceKey<CreativeModeTab> getCreativeTab() {
        if (this.properties.tab == null) {
            this.properties.tab = Services.PLATFORM.getToolsAndUtilitiesTab();
        }
        return this.properties.tab;
    }

    public int getDurability() {
        return this.getIntProperty(this.properties.durabilityConfig, this.properties.durability);
    }

    public boolean isDyeable() {
        return this.properties.dyeable;
    }

    public int getDefaultColor() {
        return this.properties.defaultColor;
    }

    public Integer getMaxTemperature() {
        return this.getIntProperty(this.properties.maxTemperatureConfig, this.properties.maxTemperature);
    }

    public Integer getUpperBreakTemperature() {
        return this.getIntProperty(this.properties.upperBreakTemperatureConfig, this.properties.upperCrackingTemperature);
    }

    public Integer getLowerBreakTemperature() {
        return this.getIntProperty(this.properties.lowerCrackingTemperatureConfig, this.properties.lowerCrackingTemperature);
    }

    public Integer getMinTemperature() {
        return this.getIntProperty(this.properties.minTemperatureConfig, this.properties.minTemperature);
    }

    private boolean isCrackingFluid(Fluid fluid) {
        return this.isElementListedInProperty(fluid, this.properties.crackingFluidsTag, this.properties.crackingFluids);
    }

    public Integer getBurningTemperature() {
        return this.getIntProperty(this.properties.burningTemperatureConfig, this.properties.burningTemperature);
    }

    public boolean isBurningFluid(Fluid fluid) {
        return this.isElementListedInProperty(fluid, this.properties.burningFluidsTag, this.properties.burningFluids);
    }

    public boolean isBurningBlock(Block block) {
        return this.isElementListedInProperty(block, this.properties.burningBlocksTag, this.properties.burningBlocks);
    }

    public Integer getFreezingTemperature() {
        return this.getIntProperty(this.properties.freezingTemperatureConfig, this.properties.freezingTemperature);
    }

    public boolean isFreezingFluid(Fluid fluid) {
        return this.isElementListedInProperty(fluid, this.properties.freezingFluidsTag, this.properties.freezingFluids);
    }

    public boolean isFreezingBlock(Block block) {
        return this.isElementListedInProperty(block, this.properties.freezingBlocksTag, this.properties.freezingBlocks);
    }

    private boolean isDeniedFluid(Fluid fluid) {
        return this.isElementListedInProperty(fluid, this.properties.deniedFluidsTag, this.properties.deniedFluids);
    }

    private boolean isAllowedFluid(Fluid fluid) {
        return this.isElementListedInProperty(fluid, this.properties.allowedFluidsTag, this.properties.allowedFluids);
    }

    public boolean canMilkEntities() {
        return this.getBooleanProperty(this.properties.milkingConfig, this.properties.milking);
    }

    private boolean canObtainEntities() {
        return this.getBooleanProperty(this.properties.entityObtainingConfig, this.properties.entityObtaining);
    }

    private boolean isDeniedEntity(EntityType<?> entityType) {
        return this.isElementListedInProperty(entityType, this.properties.deniedEntitiesTag, this.properties.deniedEntities);
    }

    private boolean isAllowedEntity(EntityType<?> entityType) {
        return this.isElementListedInProperty(entityType, this.properties.allowedEntitiesTag, this.properties.allowedEntities);
    }

    private boolean canObtainBlocks() {
        return this.getBooleanProperty(this.properties.blockObtainingConfig, this.properties.blockObtaining);
    }

    private boolean isDeniedBlock(Block block) {
        return this.isElementListedInProperty(block, this.properties.deniedBlocksTag, this.properties.deniedBlocks);
    }

    private boolean isAllowedBlock(Block block) {
        return this.isElementListedInProperty(block, this.properties.allowedBlocksTag, this.properties.allowedBlocks);
    }

    public static class Properties {
        ResourceKey<CreativeModeTab> tab = null;
        int maxStackSize = 16;
        int durability = 0;
        Supplier<Integer> durabilityConfig = null;
        boolean dyeable = false;
        int defaultColor = -1;
        Integer maxTemperature = null;
        Supplier<Integer> maxTemperatureConfig = null;
        Integer upperCrackingTemperature = null;
        Supplier<Integer> upperBreakTemperatureConfig = null;
        Integer lowerCrackingTemperature = null;
        Supplier<Integer> lowerCrackingTemperatureConfig = null;
        Integer minTemperature = null;
        Supplier<Integer> minTemperatureConfig = null;
        List<Fluid> crackingFluids = null;
        TagKey<Fluid> crackingFluidsTag = null;
        List<Fluid> deniedFluids = null;
        TagKey<Fluid> deniedFluidsTag = null;
        List<Fluid> allowedFluids = null;
        TagKey<Fluid> allowedFluidsTag = null;
        Integer burningTemperature = null;
        Supplier<Integer> burningTemperatureConfig = null;
        List<Fluid> burningFluids = null;
        TagKey<Fluid> burningFluidsTag = null;
        List<Block> burningBlocks = null;
        TagKey<Block> burningBlocksTag = null;
        Integer freezingTemperature = null;
        Supplier<Integer> freezingTemperatureConfig = null;
        List<Fluid> freezingFluids = null;
        TagKey<Fluid> freezingFluidsTag = null;
        List<Block> freezingBlocks = null;
        TagKey<Block> freezingBlocksTag = null;
        boolean milking = true;
        Supplier<Boolean> milkingConfig = null;
        boolean entityObtaining = true;
        Supplier<Boolean> entityObtainingConfig = null;
        List<EntityType<?>> deniedEntities = null;
        TagKey<EntityType<?>> deniedEntitiesTag = null;
        List<EntityType<?>> allowedEntities = null;
        TagKey<EntityType<?>> allowedEntitiesTag = null;
        boolean blockObtaining = true;
        Supplier<Boolean> blockObtainingConfig = null;
        List<Block> deniedBlocks = null;
        TagKey<Block> deniedBlocksTag = null;
        List<Block> allowedBlocks = null;
        TagKey<Block> allowedBlocksTag = null;

        public Properties tab(ResourceKey<CreativeModeTab> tab) {
            this.tab = tab;
            return this;
        }

        public Properties stacksTo(int maxStackSize) {
            if (maxStackSize < 1) {
                throw new RuntimeException("Unable to have stack size lower than 1.");
            }
            this.maxStackSize = maxStackSize;
            return this;
        }

        public Properties durability(int durability) {
            if (durability < 0) {
                throw new RuntimeException("Unable to have a durability lower than 0.");
            }
            this.durability = durability;
            return this;
        }

        public Properties durability(Supplier<Integer> durabilityConfig) {
            this.durabilityConfig = durabilityConfig;
            return this;
        }

        public Properties dyeable(int defaultColor) {
            this.dyeable = true;
            this.defaultColor = defaultColor;
            return this;
        }

        public Properties dyeable(int red, int green, int blue) {
            this.dyeable = true;
            this.defaultColor = FastColor.ARGB32.color((int)red, (int)green, (int)blue);
            return this;
        }

        public Properties maxTemperature(int maxTemperature) {
            this.maxTemperature = maxTemperature;
            return this;
        }

        public Properties maxTemperature(Supplier<Integer> maxTemperatureConfig) {
            this.maxTemperatureConfig = maxTemperatureConfig;
            return this;
        }

        public Properties upperCrackingTemperature(int upperCrackingTemperature) {
            this.upperCrackingTemperature = upperCrackingTemperature;
            return this;
        }

        public Properties upperCrackingTemperature(Supplier<Integer> upperCrackingTemperatureConfig) {
            this.upperBreakTemperatureConfig = upperCrackingTemperatureConfig;
            return this;
        }

        public Properties lowerCrackingTemperature(int lowerBreakTemperature) {
            this.lowerCrackingTemperature = lowerBreakTemperature;
            return this;
        }

        public Properties lowerCrackingTemperature(Supplier<Integer> lowerCrackingTemperatureConfig) {
            this.lowerCrackingTemperatureConfig = lowerCrackingTemperatureConfig;
            return this;
        }

        public Properties minTemperature(int minTemperature) {
            this.minTemperature = minTemperature;
            return this;
        }

        public Properties minTemperature(Supplier<Integer> minTemperatureConfig) {
            this.minTemperatureConfig = minTemperatureConfig;
            return this;
        }

        public Properties crackingFluids(List<Fluid> crackingFluids) {
            this.crackingFluids = crackingFluids;
            return this;
        }

        public Properties crackingFluids(TagKey<Fluid> crackingFluidsTag) {
            this.crackingFluidsTag = crackingFluidsTag;
            return this;
        }

        public Properties burningTemperature(int burningTemperature) {
            this.burningTemperature = burningTemperature;
            return this;
        }

        public Properties burningTemperature(Supplier<Integer> burningTemperatureConfig) {
            this.burningTemperatureConfig = burningTemperatureConfig;
            return this;
        }

        public Properties burningFluids(List<Fluid> burningFluids) {
            this.burningFluids = burningFluids;
            return this;
        }

        public Properties burningFluids(TagKey<Fluid> burningFluidsTag) {
            this.burningFluidsTag = burningFluidsTag;
            return this;
        }

        public Properties burningBlocks(List<Block> burningBlocks) {
            this.burningBlocks = burningBlocks;
            return this;
        }

        public Properties burningBlocks(TagKey<Block> burningBlocksTag) {
            this.burningBlocksTag = burningBlocksTag;
            return this;
        }

        public Properties freezingTemperature(int freezingTemperature) {
            this.freezingTemperature = freezingTemperature;
            return this;
        }

        public Properties freezingTemperature(Supplier<Integer> freezingTemperatureConfig) {
            this.freezingTemperatureConfig = freezingTemperatureConfig;
            return this;
        }

        public Properties freezingFluids(List<Fluid> freezingFluids) {
            this.freezingFluids = freezingFluids;
            return this;
        }

        public Properties freezingFluids(TagKey<Fluid> freezingFluidsTag) {
            this.freezingFluidsTag = freezingFluidsTag;
            return this;
        }

        public Properties freezingBlocks(List<Block> freezingBlocks) {
            this.freezingBlocks = freezingBlocks;
            return this;
        }

        public Properties freezingBlocks(TagKey<Block> freezingBlocksTag) {
            this.freezingBlocksTag = freezingBlocksTag;
            return this;
        }

        public Properties deniedFluids(List<Fluid> deniedFluids) {
            this.deniedFluids = deniedFluids;
            return this;
        }

        public Properties deniedFluids(TagKey<Fluid> blockedFluidsTag) {
            this.deniedFluidsTag = blockedFluidsTag;
            return this;
        }

        public Properties allowedFluids(List<Fluid> allowedFluids) {
            this.allowedFluids = allowedFluids;
            return this;
        }

        public Properties allowedFluids(TagKey<Fluid> allowedFluidsTag) {
            this.allowedFluidsTag = allowedFluidsTag;
            return this;
        }

        public Properties disableMilking() {
            this.milking = false;
            return this;
        }

        public Properties milking(Supplier<Boolean> milkingConfig) {
            this.milkingConfig = milkingConfig;
            return this;
        }

        public Properties disableEntityObtaining() {
            this.entityObtaining = false;
            return this;
        }

        public Properties entityObtaining(Supplier<Boolean> entityObtainingConfig) {
            this.entityObtainingConfig = entityObtainingConfig;
            return this;
        }

        public Properties deniedEntities(List<EntityType<?>> deniedEntities) {
            this.deniedEntities = deniedEntities;
            return this;
        }

        public Properties deniedEntities(TagKey<EntityType<?>> deniedEntitiesTag) {
            this.deniedEntitiesTag = deniedEntitiesTag;
            return this;
        }

        public Properties allowedEntities(List<EntityType<?>> allowedEntities) {
            this.allowedEntities = allowedEntities;
            return this;
        }

        public Properties allowedEntities(TagKey<EntityType<?>> allowedEntitiesTag) {
            this.allowedEntitiesTag = allowedEntitiesTag;
            return this;
        }

        public Properties disableBlockObtaining() {
            this.blockObtaining = false;
            return this;
        }

        public Properties blockObtaining(Supplier<Boolean> blockObtainingConfig) {
            this.blockObtainingConfig = blockObtainingConfig;
            return this;
        }

        public Properties deniedBlocks(List<Block> deniedBlocks) {
            this.deniedBlocks = deniedBlocks;
            return this;
        }

        public Properties deniedBlocks(TagKey<Block> deniedBlocksTag) {
            this.deniedBlocksTag = deniedBlocksTag;
            return this;
        }

        public Properties allowedBlocks(List<Block> allowedBlocks) {
            this.allowedBlocks = allowedBlocks;
            return this;
        }

        public Properties allowedBlocks(TagKey<Block> allowedBlocksTag) {
            this.allowedBlocksTag = allowedBlocksTag;
            return this;
        }
    }
}

