/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.extremereactors.gamecontent.multiblock.common;

import it.zerono.mods.extremereactors.gamecontent.multiblock.common.variant.IMultiblockEnergyGeneratorVariant;
import it.zerono.mods.zerocore.base.multiblock.AbstractMultiblockMachineController;
import it.zerono.mods.zerocore.base.multiblock.part.io.power.IPowerPort;
import it.zerono.mods.zerocore.base.multiblock.part.io.power.IPowerPortHandler;
import it.zerono.mods.zerocore.lib.data.WideAmount;
import it.zerono.mods.zerocore.lib.data.nbt.ISyncableEntity;
import it.zerono.mods.zerocore.lib.data.stack.OperationMode;
import it.zerono.mods.zerocore.lib.energy.EnergySystem;
import it.zerono.mods.zerocore.lib.energy.IWideEnergyStorage2;
import it.zerono.mods.zerocore.lib.energy.WideEnergyBuffer;
import java.util.Collection;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.Level;

public abstract class AbstractEnergyGeneratorMultiblockController<Controller extends AbstractEnergyGeneratorMultiblockController<Controller, V>, V extends IMultiblockEnergyGeneratorVariant>
extends AbstractMultiblockMachineController<Controller, V>
implements IWideEnergyStorage2 {
    protected static final EnergySystem INTERNAL_ENERGY_SYSTEM = EnergySystem.ForgeEnergy;
    private final WideEnergyBuffer _energyBuffer = this.createBuffer(INTERNAL_ENERGY_SYSTEM, WideAmount.ZERO);
    private EnergySystem _outputEnergySystem = INTERNAL_ENERGY_SYSTEM;

    public AbstractEnergyGeneratorMultiblockController(Level world) {
        super(world);
        this.setInteriorInvisible(false);
    }

    protected WideEnergyBuffer createBuffer(EnergySystem system, WideAmount capacity) {
        return new WideEnergyBuffer(INTERNAL_ENERGY_SYSTEM, WideAmount.ZERO);
    }

    protected WideEnergyBuffer getEnergyBuffer() {
        return this._energyBuffer;
    }

    public EnergySystem getOutputEnergySystem() {
        return this._outputEnergySystem;
    }

    protected void setOutputEnergySystem(EnergySystem system) {
        this._outputEnergySystem = system;
    }

    public double getEnergyStoredPercentage() {
        return this.getEnergyStored(INTERNAL_ENERGY_SYSTEM).percentage(this.getCapacity(INTERNAL_ENERGY_SYSTEM));
    }

    /*
     * WARNING - void declaration
     */
    protected static WideAmount distributeEnergyEqually(WideAmount energyAmount, Collection<? extends IPowerPort> powerTaps) {
        void var5_7;
        if (energyAmount.isZero() || powerTaps.isEmpty()) {
            return WideAmount.ZERO;
        }
        IPowerPortHandler[] outputHandlers = new IPowerPortHandler[powerTaps.size()];
        int outputHandlersCount = 0;
        for (IPowerPort iPowerPort : powerTaps) {
            IPowerPortHandler handler = iPowerPort.getPowerPortHandler();
            if (!handler.isActive() || !iPowerPort.getIoDirection().isOutput() || !handler.isConnected()) continue;
            outputHandlers[outputHandlersCount++] = handler;
        }
        if (0 == outputHandlersCount) {
            return WideAmount.ZERO;
        }
        if (1 != outputHandlersCount) {
            energyAmount = energyAmount.divide((long)outputHandlersCount);
        }
        energyAmount = energyAmount.toImmutable();
        WideAmount amountDistributed = WideAmount.ZERO;
        boolean bl = false;
        while (var5_7 < outputHandlersCount) {
            amountDistributed = amountDistributed.add(outputHandlers[var5_7].outputEnergy(energyAmount));
            ++var5_7;
        }
        return amountDistributed;
    }

    public WideAmount insertEnergy(EnergySystem system, WideAmount maxAmount, OperationMode mode) {
        return this.getEnergyBuffer().insertEnergy(system, maxAmount, mode);
    }

    public WideAmount extractEnergy(EnergySystem system, WideAmount maxAmount, OperationMode mode) {
        return this.getEnergyBuffer().extractEnergy(system, maxAmount, mode);
    }

    public WideAmount getEnergyStored(EnergySystem system) {
        return this.getEnergyBuffer().getEnergyStored(system);
    }

    public WideAmount getCapacity(EnergySystem system) {
        return this.getEnergyBuffer().getCapacity(system);
    }

    public EnergySystem getEnergySystem() {
        return this.getEnergyBuffer().getEnergySystem();
    }

    public void syncDataFrom(CompoundTag data, HolderLookup.Provider registries, ISyncableEntity.SyncReason syncReason) {
        this.syncChildDataEntityFrom((ISyncableEntity)this.getEnergyBuffer(), "buffer", data, registries, syncReason);
        if (syncReason.isNetworkUpdate()) {
            this.setOutputEnergySystem(EnergySystem.read((CompoundTag)data, (String)"energySystem", (EnergySystem)EnergySystem.REFERENCE));
        }
        super.syncDataFrom(data, registries, syncReason);
    }

    public CompoundTag syncDataTo(CompoundTag data, HolderLookup.Provider registries, ISyncableEntity.SyncReason syncReason) {
        super.syncDataTo(data, registries, syncReason);
        this.syncChildDataEntityTo((ISyncableEntity)this.getEnergyBuffer(), "buffer", data, registries, syncReason);
        if (syncReason.isNetworkUpdate()) {
            EnergySystem.write((CompoundTag)data, (String)"energySystem", (EnergySystem)this.getOutputEnergySystem());
        }
        return data;
    }
}

