/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.extremereactors.gamecontent.multiblock.common;

import it.zerono.mods.extremereactors.api.coolant.Coolant;
import it.zerono.mods.extremereactors.api.coolant.Vapor;
import it.zerono.mods.extremereactors.gamecontent.multiblock.common.FluidType;
import it.zerono.mods.extremereactors.gamecontent.multiblock.common.variant.IMultiblockFluidGeneratorVariant;
import it.zerono.mods.zerocore.lib.data.IoDirection;
import it.zerono.mods.zerocore.lib.data.stack.OperationMode;
import it.zerono.mods.zerocore.lib.item.inventory.container.ModContainer;
import it.zerono.mods.zerocore.lib.item.inventory.container.data.FluidStackData;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;

public interface IFluidContainer {
    public Optional<Fluid> getGas();

    public Optional<Fluid> getLiquid();

    public int getGasAmount();

    public int getLiquidAmount();

    default public double getGasStoredPercentage() {
        return (double)this.getGasAmount() / (double)this.getCapacity();
    }

    default public double getLiquidStoredPercentage() {
        return (double)this.getLiquidAmount() / (double)this.getCapacity();
    }

    public int getCapacity();

    public void setCapacity(int var1);

    public FluidStack extract(FluidType var1, int var2, OperationMode var3);

    public double getLiquidTemperature(double var1);

    public double onAbsorbHeat(double var1, IMultiblockFluidGeneratorVariant var3);

    public int onCondensation(int var1, boolean var2, IMultiblockFluidGeneratorVariant var3);

    public int getLiquidVaporizedLastTick();

    public IFluidHandler getWrapper(IoDirection var1);

    public Optional<Coolant> getCoolant();

    public Optional<Vapor> getVapor();

    public <T> T mapCoolant(Function<Coolant, T> var1, T var2);

    public <T> T mapVapor(Function<Vapor, T> var1, T var2);

    public FluidStackData getCoolantStackData(int var1, ModContainer var2);

    public FluidStackData getVaporStackData(int var1, ModContainer var2);
}

