/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.extremereactors.gamecontent.multiblock.reactor.part;

import com.google.common.base.Strings;
import it.zerono.mods.extremereactors.gamecontent.Content;
import it.zerono.mods.extremereactors.gamecontent.multiblock.reactor.FuelRodsLayout;
import it.zerono.mods.extremereactors.gamecontent.multiblock.reactor.IReactorReader;
import it.zerono.mods.extremereactors.gamecontent.multiblock.reactor.container.ReactorControlRodContainer;
import it.zerono.mods.extremereactors.gamecontent.multiblock.reactor.part.AbstractReactorEntity;
import it.zerono.mods.extremereactors.gamecontent.multiblock.reactor.part.ReactorFuelRodEntity;
import it.zerono.mods.zerocore.lib.CodeHelper;
import it.zerono.mods.zerocore.lib.block.AbstractModBlockEntity;
import it.zerono.mods.zerocore.lib.block.TileCommandDispatcher;
import it.zerono.mods.zerocore.lib.data.nbt.ISyncableEntity;
import it.zerono.mods.zerocore.lib.multiblock.IMultiblockPart;
import it.zerono.mods.zerocore.lib.multiblock.cuboid.PartPosition;
import it.zerono.mods.zerocore.lib.multiblock.validation.IMultiblockValidator;
import it.zerono.mods.zerocore.lib.world.WorldHelper;
import java.util.Collection;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class ReactorControlRodEntity
extends AbstractReactorEntity
implements MenuProvider {
    public static String COMMAND_SET_NAME = "setname";
    public static String COMMAND_SET_INSERTION = "setinsertion";
    private String _name = "";
    private byte _insertionRatio = 0;

    public ReactorControlRodEntity(BlockPos position, BlockState blockState) {
        super(Content.TileEntityTypes.REACTOR_CONTROLROD.get(), position, blockState);
        this.setCommandDispatcher(TileCommandDispatcher.builder().addServerHandler(COMMAND_SET_NAME, ReactorControlRodEntity::setNameFromGUI).addServerHandler(COMMAND_SET_INSERTION, ReactorControlRodEntity::setInsertionFromGUI).build((AbstractModBlockEntity)this));
    }

    public void linkToFuelRods(int fuelRodsCount) {
        CodeHelper.optionalIfPresent((Optional)this.getPartWorld(), (Optional)this.getOutwardDirection(), (world, direction) -> this.linkToFuelRods((Level)world, direction.getOpposite(), fuelRodsCount));
    }

    private void linkToFuelRods(Level world, Direction direction, int fuelRodsCount) {
        BlockPos lookupPosition = this.getWorldPosition();
        for (int i = 0; i < fuelRodsCount; ++i) {
            int rodIndex = fuelRodsCount - i - 1;
            lookupPosition = lookupPosition.relative(direction);
            CodeHelper.optionalIfPresentOrThrow(WorldHelper.getTile((Level)world, (BlockPos)lookupPosition).filter(te -> te instanceof ReactorFuelRodEntity).map(te -> (ReactorFuelRodEntity)te), rod -> rod.linkToControlRod(this, rodIndex));
        }
    }

    public FuelRodsLayout getFuelRodsLayout() {
        return (FuelRodsLayout)this.evalOnController(IReactorReader::getFuelRodsLayout, FuelRodsLayout.EMPTY);
    }

    public String getName() {
        return this._name;
    }

    public byte getInsertionRatio() {
        return this._insertionRatio;
    }

    public float getInsertionPercentage() {
        return Math.min(1.0f, Math.max(0.0f, (float)this.getInsertionRatio() / 100.0f));
    }

    public static void setName(ReactorControlRodEntity controlRod, String newName) {
        if (controlRod.setName(newName)) {
            controlRod.notifyBlockUpdate();
        }
    }

    public static void setInsertionRatio(ReactorControlRodEntity controlRod, int newRatio) {
        if (controlRod.setInsertionRatio(newRatio)) {
            controlRod.notifyBlockUpdate();
        }
    }

    public static void changeInsertionRatio(ReactorControlRodEntity controlRod, int delta) {
        if (controlRod.setInsertionRatio(controlRod.getInsertionRatio() + delta)) {
            controlRod.notifyBlockUpdate();
        }
    }

    public static void setInsertionRatio(Collection<ReactorControlRodEntity> controlRods, int newRatio) {
        Set updated = controlRods.stream().filter(IMultiblockPart::isConnected).filter(rod -> rod.setInsertionRatio(newRatio)).collect(Collectors.toSet());
        if (!updated.isEmpty()) {
            AbstractModBlockEntity.notifyBlockUpdate(updated);
        }
    }

    public static void changeInsertionRatio(Collection<ReactorControlRodEntity> controlRods, int delta) {
        Set updated = controlRods.stream().filter(IMultiblockPart::isConnected).filter(rod -> rod.setInsertionRatio(rod.getInsertionRatio() + delta)).collect(Collectors.toSet());
        if (!updated.isEmpty()) {
            AbstractModBlockEntity.notifyBlockUpdate(updated);
        }
    }

    @Nullable
    public AbstractContainerMenu createMenu(int windowId, Inventory inventory, Player player) {
        return new ReactorControlRodContainer(windowId, inventory, this);
    }

    public Component getDisplayName() {
        return super.getPartDisplayName();
    }

    public void syncDataFrom(CompoundTag data, HolderLookup.Provider registries, ISyncableEntity.SyncReason syncReason) {
        super.syncDataFrom(data, registries, syncReason);
        if (data.contains("rodInsertion")) {
            this.setInsertionRatio(data.getByte("rodInsertion"));
        }
        if (data.contains("rodName")) {
            this.setName(data.getString("rodName"));
        }
    }

    public CompoundTag syncDataTo(CompoundTag data, HolderLookup.Provider registries, ISyncableEntity.SyncReason syncReason) {
        super.syncDataTo(data, registries, syncReason);
        data.putByte("rodInsertion", this.getInsertionRatio());
        data.putString("rodName", this.getName());
        return data;
    }

    @Override
    public boolean isGoodForPosition(PartPosition position, IMultiblockValidator validatorCallback) {
        if (position.isFace()) {
            if (position.getDirection().map(direction -> this.checkForFuelRod(direction.getOpposite())).orElse(false).booleanValue()) {
                return true;
            }
            validatorCallback.setLastError(this.getWorldPosition(), "multiblock.validation.reactor.invalid_control_rods_position", new Object[0]);
            return false;
        }
        return super.isGoodForPosition(position, validatorCallback);
    }

    public boolean canOpenGui(Level world, BlockPos position, BlockState state) {
        return this.isMachineAssembled();
    }

    private void setInsertionFromGUI(CompoundTag data) {
        if (data.contains("v")) {
            if (data.getBoolean("all")) {
                this.getMultiblockController().ifPresent(c -> c.setControlRodsInsertionRatio(data.getInt("v")));
            } else {
                this.setInsertionRatio(data.getInt("v"));
            }
        }
    }

    private void setNameFromGUI(CompoundTag data) {
        if (data.contains("name")) {
            this.setName(data.getString("name"));
        }
    }

    private boolean setInsertionRatio(int newRatio) {
        if (this.getInsertionRatio() == newRatio || newRatio < 0 || newRatio > 100) {
            return false;
        }
        this._insertionRatio = (byte)newRatio;
        this.setChanged();
        this.notifyBlockUpdate();
        return true;
    }

    private boolean setName(String newName) {
        if (Strings.isNullOrEmpty((String)newName) || this.getName().equals(newName)) {
            return false;
        }
        this._name = newName;
        this.setChanged();
        this.notifyBlockUpdate();
        return true;
    }

    private boolean checkForFuelRod(Direction rodDirection) {
        return (Boolean)this.mapPartWorld(world -> WorldHelper.getLoadedTile((Level)world, (BlockPos)this.getWorldPosition().relative(rodDirection)) instanceof ReactorFuelRodEntity, false);
    }
}

