/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.core;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import dev.latvian.mods.kubejs.component.DataComponentWrapper;
import dev.latvian.mods.kubejs.component.ItemComponentFunctions;
import dev.latvian.mods.kubejs.core.IngredientSupplierKJS;
import dev.latvian.mods.kubejs.core.RegistryObjectKJS;
import dev.latvian.mods.kubejs.item.ItemStackJS;
import dev.latvian.mods.kubejs.level.BlockContainerJS;
import dev.latvian.mods.kubejs.recipe.match.ItemMatch;
import dev.latvian.mods.kubejs.recipe.match.Replaceable;
import dev.latvian.mods.kubejs.util.Cast;
import dev.latvian.mods.kubejs.util.ID;
import dev.latvian.mods.kubejs.util.RegistryAccessContainer;
import dev.latvian.mods.kubejs.util.WithCodec;
import dev.latvian.mods.kubejs.web.RelativeURL;
import dev.latvian.mods.rhino.Context;
import dev.latvian.mods.rhino.util.RemapPrefixForJS;
import dev.latvian.mods.rhino.util.ReturnsSelf;
import dev.latvian.mods.rhino.util.SpecialEquality;
import dev.latvian.mods.rhino.util.ToStringJS;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.component.DataComponentPredicate;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ItemLore;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.neoforged.neoforge.common.crafting.DataComponentIngredient;
import org.jetbrains.annotations.Nullable;

@RemapPrefixForJS(value="kjs$")
public interface ItemStackKJS
extends SpecialEquality,
WithCodec,
IngredientSupplierKJS,
ToStringJS,
Replaceable,
ItemComponentFunctions,
ItemMatch,
RegistryObjectKJS<Item> {
    default public ItemStack kjs$self() {
        return (ItemStack)this;
    }

    default public boolean specialEquals(Context cx, Object o, boolean shallow) {
        if (o instanceof CharSequence) {
            return this.kjs$getId().equals(ID.string(o.toString()));
        }
        if (o instanceof ItemStack) {
            ItemStack s = (ItemStack)o;
            return this.kjs$equalsIgnoringCount(s);
        }
        return this.kjs$equalsIgnoringCount(ItemStackJS.wrap(RegistryAccessContainer.of(cx), o));
    }

    default public boolean kjs$equalsIgnoringCount(ItemStack stack) {
        ItemStack self = this.kjs$self();
        if (self == stack) {
            return true;
        }
        if (self.isEmpty()) {
            return stack.isEmpty();
        }
        return ItemStack.isSameItemSameComponents((ItemStack)self, (ItemStack)stack);
    }

    @Override
    default public ResourceKey<Registry<Item>> kjs$getRegistryId() {
        return Registries.ITEM;
    }

    @Override
    default public Registry<Item> kjs$getRegistry() {
        return BuiltInRegistries.ITEM;
    }

    @Override
    default public ResourceLocation kjs$getIdLocation() {
        return this.kjs$self().getItem().kjs$getIdLocation();
    }

    @Override
    default public Holder<Item> kjs$asHolder() {
        return this.kjs$self().getItem().kjs$asHolder();
    }

    @Override
    default public ResourceKey<Item> kjs$getKey() {
        return this.kjs$self().getItem().kjs$getKey();
    }

    @Override
    default public String kjs$getId() {
        return this.kjs$self().getItem().kjs$getId();
    }

    @Override
    default public String kjs$getMod() {
        return this.kjs$self().getItem().kjs$getMod();
    }

    @Nullable
    default public Block kjs$getBlock() {
        Block block;
        Item item = this.kjs$self().getItem();
        if (item instanceof BlockItem) {
            BlockItem bi = (BlockItem)item;
            block = bi.getBlock();
        } else {
            block = null;
        }
        return block;
    }

    @ReturnsSelf(copy=true)
    default public ItemStack kjs$withCount(int c) {
        if (c <= 0 || this.kjs$self().isEmpty()) {
            return ItemStack.EMPTY;
        }
        ItemStack is = this.kjs$self().copy();
        is.setCount(c);
        return is;
    }

    @Override
    default public String kjs$getComponentString(Context cx) {
        return DataComponentWrapper.patchToString(new StringBuilder(), RegistryAccessContainer.of(cx).nbt(), this.kjs$self().getComponentsPatch()).toString();
    }

    @ReturnsSelf(copy=true)
    default public ItemStack kjs$withCustomName(@Nullable Component name) {
        ItemStack is = this.kjs$self().copy();
        is.kjs$setCustomName(name);
        return is;
    }

    default public ItemEnchantments kjs$getEnchantments() {
        return EnchantmentHelper.getEnchantmentsForCrafting((ItemStack)this.kjs$self());
    }

    default public boolean kjs$hasEnchantment(Holder<Enchantment> enchantment, int level) {
        ItemEnchantments e = this.kjs$getEnchantments();
        return e != null && e.getLevel(enchantment) >= level;
    }

    @ReturnsSelf
    default public ItemStack kjs$enchant(Holder<Enchantment> enchantment, int level) {
        ItemStack is = this.kjs$self();
        is.enchant(enchantment, level);
        return is;
    }

    @ReturnsSelf(copy=true)
    default public ItemStack kjs$enchant(ItemEnchantments enchantments) {
        ItemStack is = this.kjs$self().copy();
        EnchantmentHelper.updateEnchantments((ItemStack)is, mutable -> {
            for (Object2IntMap.Entry entry : enchantments.entrySet()) {
                mutable.upgrade((Holder)entry.getKey(), entry.getValue().intValue());
            }
        });
        return is;
    }

    default public boolean kjs$areItemsEqual(ItemStack other) {
        return this.kjs$self().getItem() == other.getItem();
    }

    default public boolean kjs$areComponentsEqual(ItemStack other) {
        return ItemStack.isSameItemSameComponents((ItemStack)this.kjs$self(), (ItemStack)other);
    }

    default public float kjs$getHarvestSpeed(@Nullable BlockContainerJS block) {
        return this.kjs$self().getDestroySpeed(block == null ? Blocks.AIR.defaultBlockState() : block.getBlockState());
    }

    default public float kjs$getHarvestSpeed() {
        return this.kjs$getHarvestSpeed(null);
    }

    default public Map<String, Object> kjs$getTypeData() {
        return this.kjs$self().getItem().kjs$getTypeData();
    }

    default public String toStringJS(Context cx) {
        return this.kjs$toItemString0((DynamicOps<Tag>)RegistryAccessContainer.of(cx).nbt());
    }

    default public String kjs$toItemString(Context cx) {
        return this.kjs$toItemString0((DynamicOps<Tag>)RegistryAccessContainer.of(cx).nbt());
    }

    default public String kjs$toItemString0(DynamicOps<Tag> dynamicOps) {
        ItemStack is = this.kjs$self();
        int count = is.getCount();
        if (count <= 0) {
            return "minecraft:air";
        }
        StringBuilder builder = new StringBuilder();
        builder.append('\'');
        if (count > 1) {
            builder.append(count);
            builder.append("x ");
        }
        builder.append(this.kjs$getId());
        if (!is.isComponentsPatchEmpty()) {
            DataComponentWrapper.patchToString(builder, dynamicOps, is.getComponentsPatch());
        }
        builder.append('\'');
        return builder.toString();
    }

    @Override
    default public Ingredient kjs$asIngredient() {
        DataComponentPatch p = this.kjs$self().getComponentsPatch();
        if (p.isEmpty()) {
            return this.kjs$self().getItem().kjs$asIngredient();
        }
        DataComponentMap.Builder map = DataComponentMap.builder();
        for (Map.Entry entry : p.entrySet()) {
            if (!((Optional)entry.getValue()).isPresent()) continue;
            map.set((DataComponentType)entry.getKey(), Cast.to(((Optional)entry.getValue()).get()));
        }
        return new DataComponentIngredient((HolderSet)HolderSet.direct((Holder[])new Holder[]{this.kjs$asHolder()}), DataComponentPredicate.allOf((DataComponentMap)map.build()), false).toVanilla();
    }

    default public Codec<ItemStack> getCodec(Context cx) {
        return ItemStack.CODEC;
    }

    @ReturnsSelf(copy=true)
    default public ItemStack kjs$withLore(Component[] lines) {
        ItemStack is = this.kjs$self().copy();
        is.set(DataComponents.LORE, (Object)new ItemLore(List.of(lines)));
        return is;
    }

    @ReturnsSelf(copy=true)
    default public ItemStack kjs$withLore(Component[] lines, Component[] styledLines) {
        ItemStack is = this.kjs$self().copy();
        is.set(DataComponents.LORE, (Object)new ItemLore(List.of(lines), List.of(styledLines)));
        return is;
    }

    @Override
    default public Object replaceThisWith(Context cx, Object with) {
        ItemStack r;
        ItemStack t = this.kjs$self();
        if (!ItemStack.isSameItemSameComponents((ItemStack)t, (ItemStack)(r = ItemStackJS.wrap(RegistryAccessContainer.of(cx), with)))) {
            r.setCount(t.getCount());
            return r;
        }
        return this;
    }

    @Override
    default public boolean matches(Context cx, ItemStack s, boolean exact) {
        return this.kjs$self().getItem() == s.getItem();
    }

    @Override
    default public boolean matches(Context cx, Ingredient in, boolean exact) {
        return in.test(this.kjs$self());
    }

    @Override
    default public boolean matches(Context cx, ItemLike itemLike, boolean exact) {
        return this.kjs$self().getItem() == itemLike.asItem();
    }

    default public RelativeURL kjs$getWebIconURL(DynamicOps<Tag> ops, int size) {
        String url = "/img/" + size + "/item/" + ID.url(this.kjs$getIdLocation());
        String c = DataComponentWrapper.patchToString(new StringBuilder(), ops, DataComponentWrapper.visualPatch(this.kjs$self().getComponentsPatch())).toString();
        return new RelativeURL(url, c.equals("[]") ? Map.of() : Map.of("components", c.substring(1, c.length() - 1)));
    }
}

