/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.fluid;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.serialization.DynamicOps;
import dev.latvian.mods.kubejs.component.DataComponentWrapper;
import dev.latvian.mods.kubejs.fluid.NamespaceFluidIngredient;
import dev.latvian.mods.kubejs.fluid.RegExFluidIngredient;
import dev.latvian.mods.kubejs.util.RegExpKJS;
import dev.latvian.mods.kubejs.util.RegistryAccessContainer;
import dev.latvian.mods.rhino.type.TypeInfo;
import dev.latvian.mods.rhino.util.HideFromJS;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponentPredicate;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.crafting.DataComponentFluidIngredient;
import net.neoforged.neoforge.fluids.crafting.EmptyFluidIngredient;
import net.neoforged.neoforge.fluids.crafting.FluidIngredient;
import net.neoforged.neoforge.fluids.crafting.SizedFluidIngredient;

public interface FluidWrapper {
    public static final TypeInfo TYPE_INFO = TypeInfo.of(FluidStack.class);
    public static final TypeInfo FLUID_TYPE_INFO = TypeInfo.of(Fluid.class);
    public static final TypeInfo INGREDIENT_TYPE_INFO = TypeInfo.of(FluidIngredient.class);
    public static final TypeInfo SIZED_INGREDIENT_TYPE_INFO = TypeInfo.of(SizedFluidIngredient.class);
    public static final SizedFluidIngredient EMPTY_SIZED = new SizedFluidIngredient(FluidIngredient.empty(), 1000);

    @HideFromJS
    public static FluidStack wrap(RegistryAccessContainer registries, Object o) {
        if (o == null || o == FluidStack.EMPTY || o == Fluids.EMPTY || o == EmptyFluidIngredient.INSTANCE) {
            return FluidStack.EMPTY;
        }
        if (o instanceof FluidStack) {
            FluidStack stack = (FluidStack)o;
            return stack;
        }
        if (o instanceof Fluid) {
            Fluid fluid = (Fluid)o;
            return new FluidStack(fluid, 1000);
        }
        if (o instanceof FluidIngredient) {
            FluidIngredient in = (FluidIngredient)o;
            return in.hasNoFluids() ? FluidStack.EMPTY : in.getStacks()[0];
        }
        if (o instanceof SizedFluidIngredient) {
            SizedFluidIngredient s = (SizedFluidIngredient)o;
            return s.getFluids()[0];
        }
        return FluidWrapper.ofString(registries.nbt(), o.toString());
    }

    public static FluidIngredient ingredientOf(FluidIngredient of) {
        return of;
    }

    @HideFromJS
    public static FluidIngredient wrapIngredient(RegistryAccessContainer registries, Object o) {
        if (o == null || o == FluidStack.EMPTY || o == Fluids.EMPTY || o == EmptyFluidIngredient.INSTANCE) {
            return EmptyFluidIngredient.INSTANCE;
        }
        if (o instanceof FluidStack) {
            FluidStack stack = (FluidStack)o;
            return FluidIngredient.of((FluidStack[])new FluidStack[]{stack});
        }
        if (o instanceof Fluid) {
            Fluid fluid = (Fluid)o;
            return FluidIngredient.of((Fluid[])new Fluid[]{fluid});
        }
        if (o instanceof FluidIngredient) {
            FluidIngredient in = (FluidIngredient)o;
            return in;
        }
        if (o instanceof SizedFluidIngredient) {
            SizedFluidIngredient s = (SizedFluidIngredient)o;
            return s.ingredient();
        }
        return FluidWrapper.ingredientOfString(registries.nbt(), o.toString());
    }

    public static SizedFluidIngredient sizedIngredientOf(SizedFluidIngredient of) {
        return of;
    }

    @HideFromJS
    public static SizedFluidIngredient wrapSizedIngredient(RegistryAccessContainer registries, Object o) {
        if (o == null || o == FluidStack.EMPTY || o == Fluids.EMPTY || o == EmptyFluidIngredient.INSTANCE) {
            return EMPTY_SIZED;
        }
        if (o instanceof SizedFluidIngredient) {
            SizedFluidIngredient s = (SizedFluidIngredient)o;
            return s;
        }
        if (o instanceof FluidStack) {
            FluidStack stack = (FluidStack)o;
            return SizedFluidIngredient.of((FluidStack)stack);
        }
        if (o instanceof Fluid) {
            Fluid fluid = (Fluid)o;
            return SizedFluidIngredient.of((Fluid)fluid, (int)1000);
        }
        if (o instanceof FluidIngredient) {
            FluidIngredient in = (FluidIngredient)o;
            return new SizedFluidIngredient(in, 1000);
        }
        return FluidWrapper.sizedIngredientOfString(registries.nbt(), o.toString());
    }

    public static FluidStack of(FluidStack o) {
        return o;
    }

    public static FluidStack of(FluidStack o, int amount) {
        o.setAmount(amount);
        return o;
    }

    public static FluidStack of(FluidStack o, DataComponentMap components) {
        o.applyComponents(components);
        return o;
    }

    public static FluidStack of(FluidStack o, int amount, DataComponentMap components) {
        o.setAmount(amount);
        o.applyComponents(components);
        return o;
    }

    public static FluidStack water() {
        return FluidWrapper.water(1000);
    }

    public static FluidStack lava() {
        return FluidWrapper.lava(1000);
    }

    public static FluidStack water(int amount) {
        return new FluidStack((Fluid)Fluids.WATER, amount);
    }

    public static FluidStack lava(int amount) {
        return new FluidStack((Fluid)Fluids.LAVA, amount);
    }

    public static Fluid getType(ResourceLocation id) {
        return (Fluid)BuiltInRegistries.FLUID.get(id);
    }

    public static List<String> getTypes() {
        ArrayList<String> types = new ArrayList<String>();
        for (Fluid fluid : BuiltInRegistries.FLUID) {
            types.add(fluid.kjs$getId());
        }
        return types;
    }

    public static FluidStack getEmpty() {
        return FluidStack.EMPTY;
    }

    public static boolean exists(ResourceLocation id) {
        return BuiltInRegistries.FLUID.containsKey(id);
    }

    public static ResourceLocation getId(Fluid fluid) {
        return BuiltInRegistries.FLUID.getKey((Object)fluid);
    }

    public static FluidStack ofString(DynamicOps<Tag> registryOps, String s) {
        if (s.isEmpty() || s.equals("-") || s.equals("empty") || s.equals("minecraft:empty")) {
            return FluidStack.EMPTY;
        }
        try {
            StringReader reader = new StringReader(s);
            reader.skipWhitespace();
            if (!reader.canRead()) {
                return FluidStack.EMPTY;
            }
            return FluidWrapper.read(registryOps, new StringReader(s));
        }
        catch (CommandSyntaxException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static FluidStack read(DynamicOps<Tag> registryOps, StringReader reader) throws CommandSyntaxException {
        char next;
        if (!reader.canRead()) {
            return FluidStack.EMPTY;
        }
        if (reader.peek() == '-') {
            return FluidStack.EMPTY;
        }
        long amount = FluidWrapper.readFluidAmount(reader);
        ResourceLocation fluidId = ResourceLocation.read((StringReader)reader);
        FluidStack fluidStack = new FluidStack((Fluid)BuiltInRegistries.FLUID.get(fluidId), (int)amount);
        char c = next = reader.canRead() ? reader.peek() : (char)'\u0000';
        if (next == '[' || next == '{') {
            fluidStack.applyComponents(DataComponentWrapper.readPatch(registryOps, reader));
        }
        return fluidStack;
    }

    public static FluidIngredient ingredientOfString(DynamicOps<Tag> registryOps, String s) {
        if (s.isEmpty() || s.equals("-") || s.equals("empty") || s.equals("minecraft:empty")) {
            return FluidIngredient.empty();
        }
        try {
            StringReader reader = new StringReader(s);
            reader.skipWhitespace();
            if (!reader.canRead()) {
                return FluidIngredient.empty();
            }
            return FluidWrapper.readIngredient(registryOps, new StringReader(s));
        }
        catch (CommandSyntaxException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static FluidIngredient readIngredient(DynamicOps<Tag> registryOps, StringReader reader) throws CommandSyntaxException {
        DataComponentPredicate components;
        char next;
        if (!reader.canRead()) {
            return FluidIngredient.empty();
        }
        if (reader.peek() == '-') {
            return FluidIngredient.empty();
        }
        if (reader.peek() == '#') {
            reader.skip();
            ResourceLocation tag = ResourceLocation.read((StringReader)reader);
            return FluidIngredient.tag((TagKey)FluidTags.create((ResourceLocation)tag));
        }
        if (reader.peek() == '@') {
            reader.skip();
            String id = reader.readString();
            return new NamespaceFluidIngredient(id);
        }
        if (reader.peek() == '/') {
            reader.skip();
            Pattern pattern = RegExpKJS.read(reader);
            return new RegExFluidIngredient(pattern);
        }
        ResourceLocation fluidId = ResourceLocation.read((StringReader)reader);
        Fluid fluid = (Fluid)BuiltInRegistries.FLUID.get(fluidId);
        char c = next = reader.canRead() ? reader.peek() : (char)'\u0000';
        if ((next == '[' || next == '{') && (components = DataComponentWrapper.readPredicate(registryOps, reader)) != DataComponentPredicate.EMPTY) {
            return new DataComponentFluidIngredient((HolderSet)HolderSet.direct((Holder[])new Holder[]{fluid.builtInRegistryHolder()}), components, false);
        }
        return FluidIngredient.of((Fluid[])new Fluid[]{fluid});
    }

    public static SizedFluidIngredient sizedIngredientOfString(DynamicOps<Tag> registryOps, String s) {
        if (s.isEmpty() || s.equals("-") || s.equals("empty") || s.equals("minecraft:empty")) {
            return EMPTY_SIZED;
        }
        try {
            StringReader reader = new StringReader(s);
            reader.skipWhitespace();
            if (!reader.canRead()) {
                return EMPTY_SIZED;
            }
            return FluidWrapper.readSizedIngredient(registryOps, new StringReader(s));
        }
        catch (CommandSyntaxException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static SizedFluidIngredient readSizedIngredient(DynamicOps<Tag> registryOps, StringReader reader) throws CommandSyntaxException {
        if (!reader.canRead()) {
            return EMPTY_SIZED;
        }
        long amount = FluidWrapper.readFluidAmount(reader);
        return new SizedFluidIngredient(FluidWrapper.readIngredient(registryOps, reader), (int)amount);
    }

    public static long readFluidAmount(StringReader reader) throws CommandSyntaxException {
        if (reader.canRead() && StringReader.isAllowedNumber((char)reader.peek())) {
            double amountd = reader.readDouble();
            reader.skipWhitespace();
            if (reader.peek() == 'b' || reader.peek() == 'B') {
                reader.skip();
                reader.skipWhitespace();
                amountd *= 1000.0;
            }
            if (reader.peek() == '/') {
                reader.skip();
                reader.skipWhitespace();
                amountd /= reader.readDouble();
            }
            long amount = (long)amountd;
            reader.expect('x');
            reader.skipWhitespace();
            if (amount < 1L) {
                throw new IllegalArgumentException("Fluid amount smaller than 1 is not allowed!");
            }
            return amount;
        }
        return 1000L;
    }
}

