/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.recipe;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import dev.latvian.mods.kubejs.recipe.component.ComponentRole;
import dev.latvian.mods.kubejs.recipe.component.RecipeComponent;
import dev.latvian.mods.kubejs.recipe.schema.RecipeOptional;
import dev.latvian.mods.kubejs.recipe.schema.RecipeSchemaType;
import dev.latvian.mods.kubejs.util.Cast;
import dev.latvian.mods.rhino.type.TypeInfo;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.SequencedSet;

public final class RecipeKey<T> {
    public final RecipeComponent<T> component;
    public final TypeInfo typeInfo;
    public final Codec<T> codec;
    public final String name;
    public final ComponentRole role;
    public final SequencedSet<String> names;
    public RecipeOptional<T> optional;
    public boolean excluded;
    public List<String> functionNames;
    public boolean allowEmpty;
    public boolean alwaysWrite;

    public RecipeKey(RecipeComponent<T> component, String name, ComponentRole role) {
        this.component = component;
        this.typeInfo = component.typeInfo();
        this.codec = component.codec();
        this.name = name;
        this.role = role;
        this.names = new LinkedHashSet<String>(1);
        this.names.add(name);
        this.optional = null;
        this.excluded = false;
        this.functionNames = null;
        this.allowEmpty = false;
        this.alwaysWrite = false;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.name);
        if (this.optional != null) {
            sb.append('?');
        }
        sb.append(':');
        sb.append(this.component);
        return sb.toString();
    }

    public RecipeKey<T> optional(T value) {
        return this.optional(new RecipeOptional.Constant<T>(value));
    }

    public RecipeKey<T> optional(RecipeOptional<T> value) {
        this.optional = value;
        return this;
    }

    public RecipeKey<T> defaultOptional() {
        this.optional = (RecipeOptional)Cast.to(RecipeOptional.DEFAULT);
        return this;
    }

    public boolean optional() {
        return this.optional != null;
    }

    public RecipeKey<T> alt(String name) {
        this.names.add(name);
        return this;
    }

    public RecipeKey<T> alt(String ... names) {
        this.names.addAll(List.of(names));
        return this;
    }

    public RecipeKey<T> exclude() {
        this.excluded = true;
        return this;
    }

    public RecipeKey<T> noFunctions() {
        this.functionNames = List.of();
        return this;
    }

    public RecipeKey<T> functionNames(List<String> names) {
        this.functionNames = names;
        return this;
    }

    public RecipeKey<T> allowEmpty() {
        this.allowEmpty = true;
        return this;
    }

    public RecipeKey<T> alwaysWrite() {
        this.alwaysWrite = true;
        return this;
    }

    public String getPreferredBuilderKey() {
        return this.functionNames == null ? this.name : this.functionNames.getFirst();
    }

    public JsonObject toJson(RecipeSchemaType type, DynamicOps<JsonElement> ops) {
        JsonArray a;
        JsonObject json = new JsonObject();
        json.addProperty("name", this.name);
        if (!this.role.isOther()) {
            json.addProperty("role", this.role.getSerializedName());
        }
        json.addProperty("type", this.component.toString());
        if (this.optional != null) {
            if (this.optional.isDefault()) {
                json.add("optional", (JsonElement)JsonNull.INSTANCE);
            } else {
                json.add("optional", (JsonElement)this.codec.encodeStart(ops, this.optional.getDefaultValue(type)).getOrThrow());
            }
        }
        if (this.names.size() > 1) {
            a = new JsonArray();
            for (String n : this.names) {
                if (n.equals(this.name)) continue;
                a.add(n);
            }
            json.add("alternative_names", (JsonElement)a);
        }
        if (this.excluded) {
            json.addProperty("excluded", Boolean.valueOf(true));
        }
        if (this.functionNames != null) {
            a = new JsonArray();
            this.functionNames.forEach(arg_0 -> ((JsonArray)a).add(arg_0));
            json.add("function_names", (JsonElement)a);
        }
        if (this.allowEmpty) {
            json.addProperty("allow_empty", Boolean.valueOf(true));
        }
        if (this.alwaysWrite) {
            json.addProperty("always_write", Boolean.valueOf(true));
        }
        return json;
    }
}

