/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.web;

import dev.latvian.apps.tinyserver.HTTPServer;
import dev.latvian.apps.tinyserver.ServerRegistry;
import dev.latvian.apps.tinyserver.http.HTTPHandler;
import dev.latvian.apps.tinyserver.http.HTTPMethod;
import dev.latvian.apps.tinyserver.ws.WSHandler;
import dev.latvian.apps.tinyserver.ws.WSSession;
import dev.latvian.apps.tinyserver.ws.WSSessionFactory;
import dev.latvian.mods.kubejs.web.KJSHTTPRequest;
import dev.latvian.mods.kubejs.web.LocalWebServer;
import java.util.HashSet;
import net.minecraft.util.thread.BlockableEventLoop;

public class LocalWebServerRegistry
implements ServerRegistry<KJSHTTPRequest> {
    private final BlockableEventLoop<?> eventLoop;
    final HTTPServer<KJSHTTPRequest> server;
    final HashSet<LocalWebServer.Endpoint> endpoints;

    public LocalWebServerRegistry(BlockableEventLoop<?> eventLoop) {
        this.eventLoop = eventLoop;
        this.server = new HTTPServer(this::createRequest);
        this.endpoints = new HashSet();
    }

    private KJSHTTPRequest createRequest() {
        KJSHTTPRequest request = new KJSHTTPRequest();
        request.eventLoop = this.eventLoop;
        return request;
    }

    public void http(HTTPMethod method, String path, HTTPHandler<KJSHTTPRequest> handler) {
        this.server.http(method, path, handler);
        this.endpoints.add(new LocalWebServer.Endpoint(method.name(), path));
    }

    public <WSS extends WSSession<KJSHTTPRequest>> WSHandler<KJSHTTPRequest, WSS> ws(String path, WSSessionFactory<KJSHTTPRequest, WSS> factory) {
        this.endpoints.add(new LocalWebServer.Endpoint("WS", path));
        return this.server.ws(path, factory);
    }
}

