/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.web.local;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import dev.latvian.apps.tinyserver.ServerRegistry;
import dev.latvian.apps.tinyserver.content.ResponseContent;
import dev.latvian.apps.tinyserver.http.response.HTTPResponse;
import dev.latvian.apps.tinyserver.http.response.HTTPStatus;
import dev.latvian.apps.tinyserver.ws.Frame;
import dev.latvian.apps.tinyserver.ws.WSHandler;
import dev.latvian.apps.tinyserver.ws.WSSession;
import dev.latvian.mods.kubejs.KubeJS;
import dev.latvian.mods.kubejs.KubeJSPaths;
import dev.latvian.mods.kubejs.plugin.KubeJSPlugin;
import dev.latvian.mods.kubejs.plugin.KubeJSPlugins;
import dev.latvian.mods.kubejs.script.ScriptType;
import dev.latvian.mods.kubejs.util.RegExpKJS;
import dev.latvian.mods.kubejs.web.JsonContent;
import dev.latvian.mods.kubejs.web.KJSHTTPRequest;
import dev.latvian.mods.kubejs.web.KJSWSSession;
import dev.latvian.mods.kubejs.web.LocalWebServer;
import dev.latvian.mods.kubejs.web.LocalWebServerRegistry;
import dev.latvian.mods.kubejs.web.local.ConsoleWSSession;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tags.TagKey;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.ModList;
import net.neoforged.fml.loading.FMLPaths;
import net.neoforged.neoforge.server.ServerLifecycleHooks;
import org.jetbrains.annotations.Nullable;

public class KubeJSWeb {
    public static WSHandler<KJSHTTPRequest, KJSWSSession> UPDATES = WSHandler.empty();
    private static final Map<String, Path> BROWSE = Map.of("assets", KubeJSPaths.ASSETS, "data", KubeJSPaths.DATA, "startup_scripts", KubeJSPaths.STARTUP_SCRIPTS, "client_scripts", KubeJSPaths.CLIENT_SCRIPTS, "server_scripts", KubeJSPaths.SERVER_SCRIPTS, "logs", FMLPaths.GAMEDIR.get().resolve("logs"));

    public static int broadcastEvent(@Nullable WSHandler<?, ?> handler, String event, String requiredTag, @Nullable Supplier<JsonElement> payload) {
        if (handler == null || handler.sessions().isEmpty()) {
            return 0;
        }
        Frame frame = null;
        int count = 0;
        for (WSSession s : handler.sessions().values()) {
            if (!requiredTag.isEmpty() && s instanceof KJSWSSession) {
                KJSWSSession ks = (KJSWSSession)s;
                if (!ks.info.tags().contains(requiredTag)) continue;
            }
            if (frame == null) {
                JsonElement p;
                JsonObject json = new JsonObject();
                json.addProperty("type", event);
                JsonElement jsonElement = p = payload == null ? null : payload.get();
                if (p != null && !p.isJsonNull()) {
                    json.add("payload", p);
                }
                frame = Frame.text((String)json.toString());
            }
            s.send(frame);
            ++count;
        }
        return count;
    }

    public static int broadcastUpdate(String type, String requiredTag, Supplier<JsonElement> payload) {
        return KubeJSWeb.broadcastEvent(UPDATES, type, requiredTag, payload);
    }

    public static void addScriptTypeEndpoints(ServerRegistry<KJSHTTPRequest> registry, ScriptType s, Runnable reload) {
        String path = "/api/console/" + s.name;
        s.console.wsBroadcaster = registry.ws(path + "/stream", () -> new ConsoleWSSession(s.console));
        registry.acceptPostString(path + "/info", s.console::info);
        registry.acceptPostString(path + "/warn", s.console::warn);
        registry.acceptPostString(path + "/error", s.console::error);
        registry.get(path + "/errors", s.console::getErrorsResponse);
        registry.get(path + "/warnings", s.console::getWarningsResponse);
        registry.acceptPostTask("/api/reload/" + s.name, reload);
    }

    public static void register(LocalWebServerRegistry registry) {
        UPDATES = registry.ws("/api/updates", KJSWSSession::new);
        KubeJSWeb.addScriptTypeEndpoints(registry, ScriptType.STARTUP, KubeJS.getStartupScriptManager()::reload);
        KubeJSWeb.addScriptTypeEndpoints(registry, ScriptType.SERVER, KubeJSWeb::reloadInternalServer);
        registry.get("/", KubeJSWeb::getHomepage);
        registry.get("/api", KubeJSWeb::getApi);
        registry.get("/api/mods", KubeJSWeb::getMods);
        registry.get("/api/browse", KubeJSWeb::getBrowse);
        registry.get("/api/browse/{directory}", KubeJSWeb::getBrowseDir);
        registry.get("/api/browse/{directory}/<file>", KubeJSWeb::getBrowseFile);
        registry.get("/api/registries", KubeJSWeb::getRegistriesResponse);
        registry.get("/api/registries/{namespace}/{path}/keys", KubeJSWeb::getRegistryKeysResponse);
        registry.get("/api/registries/{namespace}/{path}/match/{regex}", KubeJSWeb::getRegistryMatchResponse);
        registry.get("/api/tags/{namespace}/{path}", KubeJSWeb::getTagsResponse);
        registry.get("/api/tags/{namespace}/{path}/values/{tag-namespace}/{tag-path}", KubeJSWeb::getTagValuesResponse);
        registry.get("/api/tags/{namespace}/{path}/keys/{value-namespace}/{value-path}", KubeJSWeb::getTagKeysResponse);
    }

    private static void reloadInternalServer() {
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        if (server != null) {
            server.kjs$runCommand("/reload");
        }
    }

    private static HTTPResponse getHomepage(KJSHTTPRequest req) {
        ArrayList<Object> list = new ArrayList<Object>();
        list.add("KubeJS Local Web Server [" + KubeJS.PROXY.getWebServerWindowTitle() + "]");
        list.add("");
        list.add("Loaded Plugins:");
        for (KubeJSPlugin plugin : KubeJSPlugins.getAll()) {
            list.add("- " + plugin.getClass().getName());
        }
        list.add("");
        list.add("Loaded Mods:");
        for (ModContainer mod : ModList.get().getSortedMods()) {
            list.add("- " + mod.getModInfo().getDisplayName() + " (" + mod.getModId() + " - " + String.valueOf(mod.getModInfo().getVersion()) + ")");
        }
        return HTTPResponse.ok().text(list);
    }

    private static HTTPResponse getApi(KJSHTTPRequest req) {
        return HTTPResponse.ok().content((ResponseContent)JsonContent.array(json -> {
            for (LocalWebServer.Endpoint endpoint : LocalWebServer.instance().endpoints()) {
                json.add(endpoint.method() + " " + endpoint.path());
            }
        }));
    }

    private static HTTPResponse getMods(KJSHTTPRequest req) {
        return HTTPResponse.ok().content((ResponseContent)JsonContent.array(json -> {
            for (ModContainer mod : ModList.get().getSortedMods()) {
                JsonObject o = new JsonObject();
                o.addProperty("id", mod.getModId());
                o.addProperty("name", mod.getModInfo().getDisplayName());
                o.addProperty("version", mod.getModInfo().getVersion().toString());
                json.add((JsonElement)o);
            }
        }));
    }

    private static HTTPResponse getBrowse(KJSHTTPRequest req) {
        return HTTPResponse.ok().content((ResponseContent)JsonContent.array(json -> BROWSE.keySet().forEach(arg_0 -> ((JsonArray)json).add(arg_0))));
    }

    private static HTTPResponse getBrowseDir(KJSHTTPRequest req) {
        String dirName = req.variable("directory");
        Path dir = BROWSE.get(dirName);
        if (dir == null) {
            return HTTPStatus.NOT_FOUND;
        }
        return HTTPResponse.ok().content((ResponseContent)JsonContent.array(json -> {
            try {
                if (Files.exists(dir, new LinkOption[0])) {
                    for (Path file : Files.walk(dir, new FileVisitOption[0]).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(Files::isReadable).toList()) {
                        String fileName = file.getFileName().toString();
                        if (fileName.endsWith(".gz") && dirName.equals("logs")) continue;
                        JsonObject o = new JsonObject();
                        o.addProperty("path", dir.relativize(file).toString().replace('\\', '/'));
                        o.addProperty("name", fileName);
                        o.addProperty("modified", (Number)Files.getLastModifiedTime(file, new LinkOption[0]).toMillis());
                        json.add((JsonElement)o);
                    }
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }));
    }

    private static HTTPResponse getBrowseFile(KJSHTTPRequest req) {
        Path dir = BROWSE.get(req.variable("directory"));
        if (dir == null) {
            return HTTPStatus.NOT_FOUND;
        }
        Path file = dir.resolve(req.variable("file"));
        if (Files.notExists(file, new LinkOption[0])) {
            return HTTPStatus.NOT_FOUND;
        }
        if (!Files.isRegularFile(file, new LinkOption[0])) {
            return HTTPStatus.BAD_REQUEST;
        }
        if (!Files.isReadable(file) || !file.startsWith(dir)) {
            return HTTPStatus.FORBIDDEN;
        }
        return HTTPResponse.ok().content(file);
    }

    private static HTTPResponse getRegistriesResponse(KJSHTTPRequest req) {
        return HTTPResponse.ok().content((ResponseContent)JsonContent.array(json -> {
            for (RegistryAccess.RegistryEntry registry : req.registries().access().registries().toList()) {
                json.add(registry.key().location().toString());
            }
        }));
    }

    private static HTTPResponse getRegistryKeysResponse(KJSHTTPRequest req) {
        Optional registry = req.registries().access().registry(ResourceKey.createRegistryKey((ResourceLocation)req.id()));
        if (registry.isEmpty()) {
            return HTTPStatus.NOT_FOUND;
        }
        return HTTPResponse.ok().content((ResponseContent)JsonContent.array(json -> {
            for (ResourceLocation key : ((Registry)registry.get()).keySet()) {
                json.add(key.toString());
            }
        }));
    }

    private static HTTPResponse getRegistryMatchResponse(KJSHTTPRequest req) {
        Optional registry = req.registries().access().registry(ResourceKey.createRegistryKey((ResourceLocation)req.id()));
        if (registry.isEmpty()) {
            return HTTPStatus.NOT_FOUND;
        }
        Pattern regex = RegExpKJS.ofString(req.variable("regex"));
        if (regex == null) {
            return HTTPStatus.BAD_REQUEST;
        }
        return HTTPResponse.ok().content((ResponseContent)JsonContent.array(json -> {
            for (ResourceLocation key : ((Registry)registry.get()).keySet()) {
                String k = key.toString();
                if (!regex.matcher(k).find()) continue;
                json.add(k);
            }
        }));
    }

    private static HTTPResponse getTagsResponse(KJSHTTPRequest req) {
        Optional registry = req.registries().access().registry(ResourceKey.createRegistryKey((ResourceLocation)req.id()));
        if (registry.isEmpty()) {
            return HTTPStatus.NOT_FOUND;
        }
        return HTTPResponse.ok().content((ResponseContent)JsonContent.array(json -> {
            for (ResourceLocation tag : ((Registry)registry.get()).getTagNames().map(TagKey::location).toList()) {
                json.add(tag.toString());
            }
        }));
    }

    private static HTTPResponse getTagValuesResponse(KJSHTTPRequest req) {
        Optional registry = req.registries().access().registry(ResourceKey.createRegistryKey((ResourceLocation)req.id()));
        if (registry.isEmpty()) {
            return HTTPStatus.NOT_FOUND;
        }
        Optional tagKey = ((Registry)registry.get()).getTag(TagKey.create((ResourceKey)((Registry)registry.get()).key(), (ResourceLocation)req.id("tag-namespace", "tag-path")));
        if (tagKey.isEmpty()) {
            return HTTPStatus.NOT_FOUND;
        }
        return HTTPResponse.ok().content((ResponseContent)JsonContent.array(json -> {
            for (ResourceLocation key : ((HolderSet.Named)tagKey.get()).stream().map(Holder::unwrapKey).filter(Optional::isPresent).map(Optional::get).map(ResourceKey::location).toList()) {
                json.add(key.toString());
            }
        }));
    }

    private static HTTPResponse getTagKeysResponse(KJSHTTPRequest req) {
        Optional registry = req.registries().access().registry(ResourceKey.createRegistryKey((ResourceLocation)req.id()));
        if (registry.isEmpty()) {
            return HTTPStatus.NOT_FOUND;
        }
        Optional value = ((Registry)registry.get()).getHolder(req.id("value-namespace", "value-path"));
        if (value.isEmpty()) {
            return HTTPStatus.NOT_FOUND;
        }
        return HTTPResponse.ok().content((ResponseContent)JsonContent.array(json -> {
            for (ResourceLocation key : ((Holder.Reference)value.get()).tags().map(TagKey::location).toList()) {
                json.add(key.toString());
            }
        }));
    }
}

