/*
 * Decompiled with CFR 0.152.
 */
package com.kwpugh.gobber2.events;

import com.kwpugh.gobber2.config.ConfigJankson;
import com.kwpugh.gobber2.init.ItemInit;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;

@EventBusSubscriber
public class RepairTickEventHandler {
    static int minSlot = 0;
    static int maxSlot = 40;

    @SubscribeEvent
    public static void onPlayerTick(PlayerTickEvent.Pre event) {
        Level level = event.getEntity().level();
        Player entity = event.getEntity();
        if (entity instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)entity;
            Inventory inv2 = serverPlayer.getInventory();
            for (int slot = 0; slot < inv2.getContainerSize(); ++slot) {
                ItemStack stack = inv2.getItem(slot);
                if (stack.getItem() != ItemInit.GOBBER2_RING_REPAIR.get() || serverPlayer.tickCount % ConfigJankson.getConfig().ringRepairDelay != 0) continue;
                RepairTickEventHandler.repair(serverPlayer, inv2);
            }
        }
    }

    private static void repair(ServerPlayer serverPlayer, Inventory inv) {
        Level level = serverPlayer.level();
        if (level.isClientSide) {
            return;
        }
        switch (ConfigJankson.getConfig().ringRepairDelay) {
            case 0: {
                minSlot = 0;
                maxSlot = 40;
                break;
            }
            case 1: {
                minSlot = 0;
                maxSlot = 8;
                break;
            }
            case 2: {
                minSlot = 9;
                maxSlot = 35;
                break;
            }
            case 3: {
                minSlot = 36;
                maxSlot = 40;
                break;
            }
        }
        for (int slot = minSlot; slot < maxSlot; ++slot) {
            ItemStack target = inv.getItem(slot);
            if (target.isEmpty() || target == serverPlayer.getMainHandItem() || !target.isDamaged() || !target.getItem().isRepairable(target)) continue;
            target.setDamageValue(target.getDamageValue() - 1);
            return;
        }
    }
}

