/*
 * Decompiled with CFR 0.152.
 */
package com.kwpugh.gobber2.items.armor;

import com.kwpugh.gobber2.config.ConfigJankson;
import com.kwpugh.gobber2.init.ItemInit;
import com.kwpugh.gobber2.util.PlayerEquipUtil;
import com.kwpugh.gobber2.util.PlayerSpecialAbilities;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.Unbreakable;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class ArmorEnd
extends ArmorItem {
    public ArmorEnd(Holder<ArmorMaterial> holder, ArmorItem.Type type, Item.Properties properties) {
        super(holder, type, properties);
    }

    public void inventoryTick(@NotNull ItemStack stack, @NotNull Level level, @NotNull Entity entity, int slotId, boolean isSelected) {
        super.inventoryTick(stack, level, entity, slotId, isSelected);
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (player.level().isClientSide) {
                return;
            }
            if (PlayerEquipUtil.isWearingFullEndArmor(player)) {
                if (ConfigJankson.getConfig().enableEndArmorAutofeed) {
                    PlayerSpecialAbilities.giveRegenEffect(level, player, stack, ConfigJankson.getConfig().endArmorHunger, ConfigJankson.getConfig().endArmorSaturation);
                }
                if (ConfigJankson.getConfig().enableEndArmorNegEffectProtection) {
                    if (player.getEffect(MobEffects.BLINDNESS) != null) {
                        player.removeEffect(MobEffects.BLINDNESS);
                    }
                    if (player.getEffect(MobEffects.MOVEMENT_SLOWDOWN) != null) {
                        player.removeEffect(MobEffects.MOVEMENT_SLOWDOWN);
                    }
                    if (player.getEffect(MobEffects.DIG_SLOWDOWN) != null) {
                        player.removeEffect(MobEffects.DIG_SLOWDOWN);
                    }
                    if (player.getEffect(MobEffects.HARM) != null) {
                        player.removeEffect(MobEffects.HARM);
                    }
                    if (player.getEffect(MobEffects.CONFUSION) != null) {
                        player.removeEffect(MobEffects.CONFUSION);
                    }
                    if (player.getEffect(MobEffects.HUNGER) != null) {
                        player.removeEffect(MobEffects.HUNGER);
                    }
                    if (player.getEffect(MobEffects.POISON) != null) {
                        player.removeEffect(MobEffects.POISON);
                    }
                    if (player.getEffect(MobEffects.WITHER) != null) {
                        player.removeEffect(MobEffects.WITHER);
                    }
                    if (player.getEffect(MobEffects.UNLUCK) != null) {
                        player.removeEffect(MobEffects.UNLUCK);
                    }
                    if (player.getEffect(MobEffects.WEAKNESS) != null) {
                        player.removeEffect(MobEffects.WEAKNESS);
                    }
                }
            }
        }
    }

    public boolean isBookEnchantable(@NotNull ItemStack stack, @NotNull ItemStack book) {
        return true;
    }

    public void onCraftedBy(@NotNull ItemStack stack, @NotNull Level worldIn, @NotNull Player playerIn) {
        if (ConfigJankson.getConfig().endArmorUnbreakable) {
            stack.set(DataComponents.UNBREAKABLE, (Object)new Unbreakable(true));
        }
    }

    public boolean isValidRepairItem(@NotNull ItemStack toRepair, ItemStack repair) {
        return repair.getItem() == ItemInit.GOBBER2_INGOT_END.get();
    }

    public void appendHoverText(@NotNull ItemStack stack, @NotNull Item.TooltipContext context, @NotNull List<Component> tooltip, @NotNull TooltipFlag flagIn) {
        super.appendHoverText(stack, context, tooltip, flagIn);
        if (ConfigJankson.getConfig().enableEndArmorFireProtection || ConfigJankson.getConfig().enableEndArmorWaterBreathing || ConfigJankson.getConfig().enableEndArmorAutofeed || ConfigJankson.getConfig().enableEndArmorNoFallDamage || ConfigJankson.getConfig().enableEndArmorNegEffectProtection) {
            tooltip.add((Component)Component.translatable((String)"item.gobber2.gobber2_armor_end.tip1").withStyle(ChatFormatting.GREEN));
        }
        if (ConfigJankson.getConfig().enableEndArmorFireProtection) {
            tooltip.add((Component)Component.translatable((String)"item.gobber2.gobber2_armor_end.tip2").withStyle(ChatFormatting.GREEN));
        }
        if (ConfigJankson.getConfig().enableEndArmorWaterBreathing) {
            tooltip.add((Component)Component.translatable((String)"item.gobber2.gobber2_armor_end.tip3").withStyle(ChatFormatting.GREEN));
        }
        if (ConfigJankson.getConfig().enableEndArmorAutofeed) {
            tooltip.add((Component)Component.translatable((String)"item.gobber2.gobber2_armor_end.tip4").withStyle(ChatFormatting.GREEN));
            tooltip.add((Component)Component.translatable((String)"item.gobber2.gobber2_armor_end.tip5").withStyle(ChatFormatting.GREEN));
        }
        if (ConfigJankson.getConfig().enableEndArmorNoFallDamage) {
            tooltip.add((Component)Component.translatable((String)"item.gobber2.gobber2_armor_end.tip6").withStyle(ChatFormatting.GREEN));
        }
        if (ConfigJankson.getConfig().enableEndArmorNegEffectProtection) {
            tooltip.add((Component)Component.translatable((String)"item.gobber2.gobber2_armor_end.tip7").withStyle(ChatFormatting.GREEN));
        }
    }
}

