/*
 * Decompiled with CFR 0.152.
 */
package com.kwpugh.gobber2.items.armor;

import com.kwpugh.gobber2.config.ConfigJankson;
import com.kwpugh.gobber2.init.ItemInit;
import com.kwpugh.gobber2.util.PlayerEquipUtil;
import com.kwpugh.gobber2.util.PlayerSpecialAbilities;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class ArmorNether
extends ArmorItem {
    public ArmorNether(Holder<ArmorMaterial> holder, ArmorItem.Type type, Item.Properties properties) {
        super(holder, type, properties);
    }

    public void inventoryTick(@NotNull ItemStack stack, @NotNull Level level, @NotNull Entity entity, int slotId, boolean isSelected) {
        super.inventoryTick(stack, level, entity, slotId, isSelected);
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (player.level().isClientSide) {
                return;
            }
            if (PlayerEquipUtil.isWearingFullNetherArmor(player)) {
                if (ConfigJankson.getConfig().enableNetherArmorAutofeed) {
                    PlayerSpecialAbilities.giveRegenEffect(level, player, stack, ConfigJankson.getConfig().netherArmorHunger, ConfigJankson.getConfig().netherArmorSaturation);
                }
                if (ConfigJankson.getConfig().enableNetherArmorPoisonWitherCuring) {
                    if (player.getEffect(MobEffects.POISON) != null) {
                        player.removeEffect(MobEffects.POISON);
                    }
                    if (player.getEffect(MobEffects.WITHER) != null) {
                        player.removeEffect(MobEffects.WITHER);
                    }
                }
            }
        }
    }

    public boolean isBookEnchantable(@NotNull ItemStack stack, @NotNull ItemStack book) {
        return true;
    }

    public boolean isValidRepairItem(@NotNull ItemStack toRepair, ItemStack repair) {
        return repair.getItem() == ItemInit.GOBBER2_INGOT_NETHER.get();
    }

    public void appendHoverText(@NotNull ItemStack stack, @NotNull Item.TooltipContext context, @NotNull List<Component> tooltip, @NotNull TooltipFlag flagIn) {
        super.appendHoverText(stack, context, tooltip, flagIn);
        if (ConfigJankson.getConfig().enableNetherArmorFireProtection || ConfigJankson.getConfig().enableNetherArmorAutofeed || ConfigJankson.getConfig().enableNetherArmorPoisonWitherCuring) {
            tooltip.add((Component)Component.translatable((String)"item.gobber2.gobber2_armor_nether.tip1").withStyle(ChatFormatting.GREEN));
        }
        if (ConfigJankson.getConfig().enableNetherArmorFireProtection) {
            tooltip.add((Component)Component.translatable((String)"item.gobber2.gobber2_armor_nether.tip2").withStyle(ChatFormatting.GREEN));
        }
        if (ConfigJankson.getConfig().enableNetherArmorAutofeed) {
            tooltip.add((Component)Component.translatable((String)"item.gobber2.gobber2_armor_nether.tip3").withStyle(ChatFormatting.GREEN));
            tooltip.add((Component)Component.translatable((String)"item.gobber2.gobber2_armor_nether.tip4").withStyle(ChatFormatting.GREEN));
        }
        if (ConfigJankson.getConfig().enableNetherArmorPoisonWitherCuring) {
            tooltip.add((Component)Component.translatable((String)"item.gobber2.gobber2_armor_nether.tip5").withStyle(ChatFormatting.GREEN));
        }
    }
}

