/*
 * Decompiled with CFR 0.152.
 */
package com.kwpugh.gobber2.items.rings;

import com.kwpugh.gobber2.config.ConfigJankson;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.chunk.LevelChunk;
import org.jetbrains.annotations.NotNull;

public class RingAbove
extends Item {
    public RingAbove(Item.Properties properties) {
        super(properties);
    }

    public InteractionResultHolder<ItemStack> use(Level world, Player player, InteractionHand hand) {
        ItemStack stack;
        block5: {
            stack = player.getItemInHand(hand);
            if (!world.dimension().equals(Level.OVERWORLD)) {
                player.displayClientMessage((Component)Component.translatable((String)"item.gobber2.gobber2_ring_above.line5"), true);
            }
            player.getCooldowns().addCooldown((Item)this, ConfigJankson.getConfig().ringAboveCooldown);
            if (world.isClientSide || !world.dimension().equals(Level.OVERWORLD)) break block5;
            if (player.isShiftKeyDown()) {
                double x = player.getX();
                double y = 0.0;
                double z = player.getZ();
                LevelChunk chunk = world.getChunk((int)player.getX() >> 4, (int)player.getZ() >> 4);
                while (y < (double)world.getMaxBuildHeight()) {
                    BlockPos headPos;
                    BlockPos legPos;
                    BlockPos groundPos = new BlockPos((int)x, (int)((y += 1.0) + 2.0), (int)z);
                    if (chunk.getBlockState(groundPos).getBlock().equals(Blocks.AIR) || !chunk.getBlockState(legPos = new BlockPos((int)x, (int)(y + 1.0), (int)z)).getBlock().equals(Blocks.AIR) || !chunk.getBlockState(headPos = new BlockPos((int)x, (int)y, (int)z)).getBlock().equals(Blocks.AIR)) continue;
                    player.stopRiding();
                    ((ServerPlayer)player).connection.teleport(x, y, z, player.yRotO, player.xRotO);
                    return InteractionResultHolder.success((Object)stack);
                }
            } else {
                double x = player.getX();
                double y = 255.0;
                double z = player.getZ();
                LevelChunk chunk = world.getChunk((int)player.getX() >> 4, (int)player.getZ() >> 4);
                while (y > 0.0) {
                    BlockPos headPos;
                    BlockPos legPos;
                    BlockPos groundPos = new BlockPos((int)x, (int)((y -= 1.0) - 2.0), (int)z);
                    if (chunk.getBlockState(groundPos).getBlock().equals(Blocks.AIR) || !chunk.getBlockState(legPos = new BlockPos((int)x, (int)(y - 1.0), (int)z)).getBlock().equals(Blocks.AIR) || !chunk.getBlockState(headPos = new BlockPos((int)x, (int)y, (int)z)).getBlock().equals(Blocks.AIR)) continue;
                    player.stopRiding();
                    ((ServerPlayer)player).connection.teleport(x, y, z, player.yRotO, player.xRotO);
                    return InteractionResultHolder.success((Object)stack);
                }
            }
        }
        return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)stack);
    }

    public void appendHoverText(@NotNull ItemStack stack, @NotNull Item.TooltipContext context, @NotNull List<Component> tooltip, @NotNull TooltipFlag flagIn) {
        super.appendHoverText(stack, context, tooltip, flagIn);
        tooltip.add((Component)Component.translatable((String)"item.gobber2.gobber2_ring_above.line1").withStyle(ChatFormatting.GREEN));
        tooltip.add((Component)Component.translatable((String)"item.gobber2.gobber2_ring_above.line2").withStyle(ChatFormatting.YELLOW));
        tooltip.add((Component)Component.translatable((String)"item.gobber2.gobber2_ring_above.line3").withStyle(ChatFormatting.YELLOW));
        tooltip.add((Component)Component.translatable((String)"item.gobber2.gobber2_ring_above.line4").withStyle(ChatFormatting.RED));
        tooltip.add((Component)Component.translatable((String)"item.gobber2.gobber2_ring.cooldown", (Object[])new Object[]{ConfigJankson.getConfig().ringAboveCooldown}).withStyle(ChatFormatting.LIGHT_PURPLE));
    }
}

