/*
 * Decompiled with CFR 0.152.
 */
package com.kwpugh.gobber2.items.rings;

import com.kwpugh.gobber2.config.ConfigJankson;
import com.kwpugh.gobber2.init.BlockInit;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

public class RingAirwalking
extends Item {
    public RingAirwalking(Item.Properties properties) {
        super(properties);
    }

    public void inventoryTick(@NotNull ItemStack stack, Level world, @NotNull Entity entity, int itemSlot, boolean isSelected) {
        Player player = (Player)entity;
        ItemStack equipped = player.getMainHandItem();
        if (!world.isClientSide) {
            if (stack == equipped) {
                player.setNoGravity(true);
            } else {
                player.setNoGravity(false);
            }
        }
    }

    @Nonnull
    public InteractionResultHolder<ItemStack> use(Level world, @NotNull Player player, @Nonnull InteractionHand hand) {
        if (!world.isClientSide && ConfigJankson.getConfig().ringAirWalkingGlass) {
            BlockPos pos = BlockPos.containing((double)player.position().x, (double)(player.position().y - 1.0), (double)player.position().z);
            Block glassBlock = (Block)BlockInit.CLEAR_GLASS.get();
            BlockState glassDefaultState = glassBlock.defaultBlockState();
            if (world.isEmptyBlock(pos) || !world.getFluidState(pos).isEmpty()) {
                world.setBlockAndUpdate(pos, glassDefaultState);
            }
        }
        return new InteractionResultHolder(InteractionResult.PASS, (Object)player.getItemInHand(hand));
    }

    public void appendHoverText(@NotNull ItemStack stack, @NotNull Item.TooltipContext context, @NotNull List<Component> tooltip, @NotNull TooltipFlag flagIn) {
        super.appendHoverText(stack, context, tooltip, flagIn);
        tooltip.add((Component)Component.translatable((String)"item.gobber2.gobber2_ring_airwalking.line1").withStyle(ChatFormatting.GREEN));
        tooltip.add((Component)Component.translatable((String)"item.gobber2.works_in_main_hand").withStyle(ChatFormatting.YELLOW));
        if (ConfigJankson.getConfig().ringAirWalkingGlass) {
            tooltip.add((Component)Component.translatable((String)"item.gobber2.gobber2_ring_airwalking.line2").withStyle(ChatFormatting.YELLOW));
        }
    }
}

