/*
 * Decompiled with CFR 0.152.
 */
package com.kwpugh.gobber2.items.rings;

import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class RingAscent
extends Item {
    public RingAscent(Item.Properties properties) {
        super(properties);
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(@NotNull Level world, @NotNull Player player, @NotNull InteractionHand hand) {
        InteractionResultHolder result = super.use(world, player, hand);
        ItemStack stack = player.getItemInHand(hand);
        ItemStack equippedOff = player.getOffhandItem();
        ItemStack equippedMain = player.getMainHandItem();
        if (equippedMain == stack) {
            // empty if block
        }
        if (equippedOff == stack && !world.isClientSide && player.onGround()) {
            player.addEffect(new MobEffectInstance(MobEffects.LEVITATION, 3600, 0, false, false));
        }
        return result;
    }

    public void inventoryTick(@NotNull ItemStack stack, @NotNull Level world, @NotNull Entity entity, int itemSlot, boolean isSelected) {
        Player player;
        if (entity instanceof Player && (player = (Player)entity).isCrouching() && ((LivingEntity)entity).getEffect(MobEffects.LEVITATION) != null) {
            ((LivingEntity)entity).removeEffectNoUpdate(MobEffects.LEVITATION);
        }
    }

    public void appendHoverText(@NotNull ItemStack stack, @NotNull Item.TooltipContext context, @NotNull List<Component> tooltip, @NotNull TooltipFlag flagIn) {
        super.appendHoverText(stack, context, tooltip, flagIn);
        tooltip.add((Component)Component.translatable((String)"item.gobber2.gobber2_ring_ascent.line1").withStyle(ChatFormatting.GREEN));
        tooltip.add((Component)Component.translatable((String)"item.gobber2.gobber2_ring_ascent.line2").withStyle(ChatFormatting.GREEN));
        tooltip.add((Component)Component.translatable((String)"item.gobber2.gobber2_ring_ascent.line4").withStyle(ChatFormatting.RED));
    }
}

