/*
 * Decompiled with CFR 0.152.
 */
package com.kwpugh.gobber2.items.rings;

import com.kwpugh.gobber2.config.ConfigJankson;
import com.kwpugh.gobber2.util.HitResultUtil;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.HitResult;
import org.jetbrains.annotations.NotNull;

public class RingBlink
extends Item {
    public RingBlink(Item.Properties properties) {
        super(properties);
    }

    public InteractionResultHolder<ItemStack> use(Level world, Player player, InteractionHand hand) {
        int side;
        HitResult pos;
        ItemStack stack = player.getItemInHand(hand);
        player.getCooldowns().addCooldown((Item)this, ConfigJankson.getConfig().ringBlinkCooldown);
        if (!world.isClientSide && (pos = HitResultUtil.getNearestPositionWithAir(world, player, 100)) != null && (pos.getType() == HitResult.Type.BLOCK || player.xRotO >= -5.0f) && (side = pos.getType().ordinal()) != -1) {
            double x = pos.getLocation().x - (side == 4 ? 0.5 : 0.0) + (side == 5 ? 0.5 : 0.0);
            double y = pos.getLocation().y - (side == 0 ? 2.0 : 0.0) + (side == 1 ? 0.5 : 0.0);
            double z = pos.getLocation().z - (side == 2 ? 0.5 : 0.0) + (side == 3 ? 0.5 : 0.0);
            player.stopRiding();
            ((ServerPlayer)player).connection.teleport(x, y, z, player.yRotO, player.xRotO);
            world.playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.ENDERMAN_TELEPORT, SoundSource.PLAYERS, 1.0f, 1.0f);
            return InteractionResultHolder.success((Object)stack);
        }
        return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)stack);
    }

    public void appendHoverText(@NotNull ItemStack stack, @NotNull Item.TooltipContext context, @NotNull List<Component> tooltip, @NotNull TooltipFlag flagIn) {
        super.appendHoverText(stack, context, tooltip, flagIn);
        tooltip.add((Component)Component.translatable((String)"item.gobber2.gobber2_ring_blink.line1").withStyle(ChatFormatting.GREEN));
        tooltip.add((Component)Component.translatable((String)"item.gobber2.gobber2_ring_blink.line2").withStyle(ChatFormatting.YELLOW));
        tooltip.add((Component)Component.translatable((String)"item.gobber2.gobber2_ring_blink.line3").withStyle(ChatFormatting.RED));
        tooltip.add((Component)Component.translatable((String)"item.gobber2.gobber2_ring.cooldown", (Object[])new Object[]{ConfigJankson.getConfig().ringBlinkCooldown}).withStyle(ChatFormatting.LIGHT_PURPLE));
    }
}

