/*
 * Decompiled with CFR 0.152.
 */
package com.kwpugh.gobber2.items.rings;

import com.kwpugh.gobber2.config.ConfigJankson;
import java.util.List;
import java.util.Random;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.chunk.LevelChunk;
import org.jetbrains.annotations.NotNull;

public class RingExplorer
extends Item {
    public RingExplorer(Item.Properties properties) {
        super(properties);
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(Level world, Player player, @NotNull InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        player.getCooldowns().addCooldown((Item)this, ConfigJankson.getConfig().ringExplorerCooldown);
        if (!world.dimension().equals(Level.OVERWORLD)) {
            player.displayClientMessage((Component)Component.translatable((String)"item.gobber2.gobber2_ring_above.line5"), true);
            return InteractionResultHolder.success((Object)stack);
        }
        if (!world.isClientSide) {
            ServerLevel serverWorld = (ServerLevel)world;
            BlockPos worldSpawn = serverWorld.getSharedSpawnPos();
            BlockPos playerPos = player.getOnPos();
            Random rand = new Random();
            int x = Math.round(worldSpawn.getX()) + rand.nextInt(ConfigJankson.getConfig().ringExplorerMaxRange + ConfigJankson.getConfig().ringExplorerMinRange) - ConfigJankson.getConfig().ringExplorerMinRange;
            int y = 200;
            int z = Math.round(worldSpawn.getZ()) + rand.nextInt(ConfigJankson.getConfig().ringExplorerMaxRange + ConfigJankson.getConfig().ringExplorerMinRange) - ConfigJankson.getConfig().ringExplorerMinRange;
            LevelChunk chunk = world.getChunk(x >> 4, z >> 4);
            while (y > 62) {
                BlockPos headPos;
                BlockPos legPos;
                BlockPos groundPos;
                if (chunk.getBlockState(groundPos = new BlockPos(x, --y - 2, z)).getBlock().equals(Blocks.AIR) || chunk.getBlockState(groundPos).getBlock().equals(Blocks.BEDROCK) || chunk.getBlockState(groundPos).getBlock().equals(Blocks.WATER) || y - 2 <= 60 || !chunk.getBlockState(legPos = new BlockPos(x, y - 1, z)).getBlock().equals(Blocks.AIR) || !chunk.getBlockState(headPos = new BlockPos(x, y, z)).getBlock().equals(Blocks.AIR)) continue;
                player.stopRiding();
                ((ServerPlayer)player).connection.teleport((double)x, (double)y, (double)z, player.yRotO, player.xRotO);
                world.playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.ENDERMAN_TELEPORT, SoundSource.PLAYERS, 1.0f, 1.0f);
                return InteractionResultHolder.success((Object)stack);
            }
            player.displayClientMessage((Component)Component.translatable((String)"Sorry, no spot found, try again after cooldown"), true);
            return InteractionResultHolder.success((Object)stack);
        }
        return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)stack);
    }

    public void appendHoverText(@NotNull ItemStack stack, @NotNull Item.TooltipContext context, @NotNull List<Component> tooltip, @NotNull TooltipFlag flagIn) {
        super.appendHoverText(stack, context, tooltip, flagIn);
        tooltip.add((Component)Component.translatable((String)"item.gobber2.gobber2_ring_explorer.line1").withStyle(ChatFormatting.GREEN));
        tooltip.add((Component)Component.translatable((String)"item.gobber2.gobber2_ring_explorer.line2", (Object[])new Object[]{ConfigJankson.getConfig().ringExplorerMinRange, ConfigJankson.getConfig().ringExplorerMaxRange}).withStyle(ChatFormatting.GREEN));
        tooltip.add((Component)Component.translatable((String)"item.gobber2.right_click_use").withStyle(ChatFormatting.YELLOW));
        tooltip.add((Component)Component.translatable((String)"item.gobber2.gobber2_ring.cooldown", (Object[])new Object[]{ConfigJankson.getConfig().ringExplorerCooldown}).withStyle(ChatFormatting.LIGHT_PURPLE));
    }
}

