/*
 * Decompiled with CFR 0.152.
 */
package com.kwpugh.gobber2.items.rings;

import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class RingReturn
extends Item {
    private static int duration = 25;

    public RingReturn(Item.Properties properties) {
        super(properties);
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public InteractionResultHolder<ItemStack> use(@NotNull Level world, Player player, @NotNull InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (!(player instanceof ServerPlayer)) return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)stack);
        ServerPlayer serverPlayer = (ServerPlayer)player;
        if (world.isClientSide()) return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)stack);
        if (!world.dimension().equals(Level.OVERWORLD)) {
            player.displayClientMessage((Component)Component.translatable((String)"item.gobber2.ring_return.line4").withStyle(ChatFormatting.GREEN), true);
            return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)stack);
        }
        if (serverPlayer.getRespawnPosition() == null) {
            player.displayClientMessage((Component)Component.translatable((String)"item.gobber2.ring_return.line2"), true);
            return new InteractionResultHolder(InteractionResult.PASS, (Object)stack);
        }
        BlockPos bedLoc = serverPlayer.getRespawnPosition();
        if (player.isPassenger()) {
            player.stopRiding();
        }
        this.setPositionAndUpdate((LivingEntity)serverPlayer, world, bedLoc);
        player.displayClientMessage((Component)Component.translatable((String)"item.gobber2.ring_return.line1"), true);
        return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)stack);
    }

    public void setPositionAndUpdate(LivingEntity entity, Level world, BlockPos bedLoc) {
        entity.teleportTo((double)((float)bedLoc.getX() + 0.5f), (double)((float)bedLoc.getY() + 0.6f), (double)((float)bedLoc.getZ() + 0.5f));
        entity.fallDistance = 0.0f;
    }

    @NotNull
    public UseAnim getUseAnimation(@NotNull ItemStack stack) {
        return UseAnim.BOW;
    }

    public void appendHoverText(@NotNull ItemStack stack, @NotNull Item.TooltipContext context, @NotNull List<Component> tooltip, @NotNull TooltipFlag flagIn) {
        super.appendHoverText(stack, context, tooltip, flagIn);
        tooltip.add((Component)Component.translatable((String)"item.gobber2.ring_return.line3").withStyle(ChatFormatting.GREEN));
        tooltip.add((Component)Component.translatable((String)"item.gobber2.ring_return.line2").withStyle(ChatFormatting.YELLOW));
        tooltip.add((Component)Component.translatable((String)"item.gobber2.ring_return.line4").withStyle(ChatFormatting.LIGHT_PURPLE));
    }
}

