/*
 * Decompiled with CFR 0.152.
 */
package com.kwpugh.gobber2.items.rings;

import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class RingTraveler
extends Item {
    public RingTraveler(Item.Properties properties) {
        super(properties);
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(@NotNull Level world, @NotNull Player player, @NotNull InteractionHand hand) {
        InteractionResultHolder result = super.use(world, player, hand);
        Vec3 look = player.getLookAngle().normalize();
        double lookX = look.x;
        double lookY = look.y;
        double lookZ = look.z;
        if (player.onGround() && !player.isCrouching()) {
            player.setDeltaMovement(lookX * 0.0, lookY * 4.5, lookZ * 0.0);
        }
        if (!player.onGround()) {
            player.push(lookX * 0.6, lookY * 0.3, lookZ * 0.6);
        }
        return result;
    }

    public void appendHoverText(@NotNull ItemStack stack, @NotNull Item.TooltipContext context, @NotNull List<Component> tooltip, @NotNull TooltipFlag flagIn) {
        super.appendHoverText(stack, context, tooltip, flagIn);
        tooltip.add((Component)Component.translatable((String)"item.gobber2.gobber2_ring_traveler.line1").withStyle(ChatFormatting.GREEN));
        tooltip.add((Component)Component.translatable((String)"item.gobber2.right_click_use").withStyle(ChatFormatting.YELLOW));
    }
}

