/*
 * Decompiled with CFR 0.152.
 */
package com.kwpugh.gobber2.items.staffs;

import com.kwpugh.gobber2.util.CatcherUtil;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class StaffEnsnarement
extends Item {
    public StaffEnsnarement(Item.Properties properties) {
        super(properties);
    }

    @NotNull
    public InteractionResult useOn(UseOnContext iuc) {
        Level level = iuc.getLevel();
        if (level.isClientSide) {
            return InteractionResult.FAIL;
        }
        ItemStack stack = iuc.getItemInHand();
        if (CatcherUtil.hasEntity(stack)) {
            CatcherUtil.respawnEntity(iuc, stack);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.FAIL;
    }

    public boolean isFoil(@NotNull ItemStack stack) {
        return CatcherUtil.hasEntity(stack);
    }

    public void appendHoverText(@NotNull ItemStack stack, @NotNull Item.TooltipContext context, @NotNull List<Component> tooltip, @NotNull TooltipFlag flagIn) {
        super.appendHoverText(stack, context, tooltip, flagIn);
        tooltip.add((Component)Component.translatable((String)"item.gobber2.gobber2_staff_ensnarement.line1").withStyle(ChatFormatting.GREEN));
        tooltip.add((Component)Component.translatable((String)"item.gobber2.gobber2_staff_ensnarement.line2").withStyle(ChatFormatting.GREEN));
        if (CatcherUtil.hasEntity(stack)) {
            tooltip.add((Component)Component.translatable((String)"item.gobber2.gobber2_staff_ensnarement.line4", (Object[])new Object[]{CatcherUtil.getEntityId(stack)}).withStyle(ChatFormatting.DARK_PURPLE));
        } else {
            tooltip.add((Component)Component.translatable((String)"item.gobber2.gobber2_staff_ensnarement.line3").withStyle(ChatFormatting.LIGHT_PURPLE));
        }
        tooltip.add((Component)Component.translatable((String)"item.gobber2.gobber2_staff_ensnarement.line5").withStyle(ChatFormatting.AQUA));
        tooltip.add((Component)Component.translatable((String)"item.gobber2.gobber2_staff_ensnarement.line6").withStyle(ChatFormatting.YELLOW));
    }
}

