/*
 * Decompiled with CFR 0.152.
 */
package com.kwpugh.gobber2.items.tools.basetools;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public abstract class ModBow
extends BowItem {
    private final float speed;
    private final float divergence;
    private final int dropDistance;
    private final boolean critical;

    public ModBow(Item.Properties properties, float speed, float divergence, int dropDistance, boolean critical) {
        super(properties);
        this.speed = speed;
        this.divergence = divergence;
        this.dropDistance = dropDistance;
        this.critical = critical;
    }

    public void releaseUsing(@NotNull ItemStack stack, @NotNull Level level, @NotNull LivingEntity livingEntity, int timeLeft) {
        int i;
        float f;
        Player player;
        ItemStack itemstack;
        if (livingEntity instanceof Player && !(itemstack = (player = (Player)livingEntity).getProjectile(stack)).isEmpty() && !((double)(f = ModBow.getPowerForTime((int)(i = this.getUseDuration(stack, livingEntity) - timeLeft))) < 0.1)) {
            List list = ModBow.draw((ItemStack)stack, (ItemStack)itemstack, (LivingEntity)player);
            if (level instanceof ServerLevel) {
                ServerLevel serverlevel = (ServerLevel)level;
                if (!list.isEmpty()) {
                    this.shoot(serverlevel, (LivingEntity)player, player.getUsedItemHand(), stack, list, this.speed, this.divergence, this.critical, null);
                }
            }
            level.playSound((Player)null, player.getX(), player.getY(), player.getZ(), SoundEvents.ARROW_SHOOT, SoundSource.PLAYERS, 1.0f, 1.0f / (level.getRandom().nextFloat() * 0.4f + 1.2f) + f * 0.5f);
            player.awardStat(Stats.ITEM_USED.get((Object)this));
        }
    }

    public void shoot(@NotNull ServerLevel serverLevel, @NotNull LivingEntity livingEntity, @NotNull InteractionHand hand, @NotNull ItemStack stack, List<ItemStack> list, float speed, float divergence, boolean critical, @Nullable LivingEntity target) {
        float f = EnchantmentHelper.processProjectileSpread((ServerLevel)serverLevel, (ItemStack)stack, (Entity)livingEntity, (float)0.0f);
        float f1 = list.size() == 1 ? 0.0f : 2.0f * f / (float)(list.size() - 1);
        float f2 = (float)((list.size() - 1) % 2) * f1 / 2.0f;
        float f3 = 1.0f;
        for (int i = 0; i < list.size(); ++i) {
            ItemStack itemstack = list.get(i);
            if (itemstack.isEmpty()) continue;
            float f4 = f2 + f3 * (float)((i + 1) / 2) * f1;
            f3 = -f3;
            Projectile projectile = this.createProjectile((Level)serverLevel, livingEntity, stack, itemstack, critical);
            this.shootProjectile(livingEntity, projectile, i, speed, divergence, f4, target);
            serverLevel.addFreshEntity((Entity)projectile);
            stack.hurtAndBreak(this.getDurabilityUse(itemstack), livingEntity, LivingEntity.getSlotForHand((InteractionHand)hand));
            if (stack.isEmpty()) break;
        }
    }

    public int getDefaultProjectileRange() {
        return this.dropDistance;
    }
}

