/*
 * Decompiled with CFR 0.152.
 */
package com.kwpugh.gobber2.items.tools.endtools;

import com.kwpugh.gobber2.config.ConfigJankson;
import com.kwpugh.gobber2.init.TagInit;
import com.kwpugh.gobber2.items.tools.basetools.PaxelBase;
import com.kwpugh.gobber2.util.EnableUtil;
import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.Unbreakable;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.common.ItemAbilities;
import org.jetbrains.annotations.NotNull;

public class PaxelEndStars
extends PaxelBase {
    public PaxelEndStars(Tier tier, TagKey<Block> mineable, Item.Properties builder) {
        super(tier, TagInit.PAXEL_MINEABLE, builder);
    }

    @Override
    @NotNull
    public InteractionResult useOn(UseOnContext context) {
        BlockPos torchPos;
        BlockPos pos = context.getClickedPos();
        Level world = context.getLevel();
        BlockPos blockpos = context.getClickedPos();
        Player player = context.getPlayer();
        ItemStack stack = player.getMainHandItem();
        BlockState blockstate = world.getBlockState(blockpos);
        if (!EnableUtil.isEnabled(stack)) {
            Level level = context.getLevel();
            Optional<BlockState> optional = Optional.ofNullable(blockstate.getToolModifiedState(context, ItemAbilities.AXE_STRIP, false));
            Optional<BlockState> optional1 = Optional.ofNullable(blockstate.getToolModifiedState(context, ItemAbilities.AXE_SCRAPE, false));
            Optional<BlockState> optional2 = Optional.ofNullable(blockstate.getToolModifiedState(context, ItemAbilities.AXE_WAX_OFF, false));
            ItemStack itemstack = context.getItemInHand();
            Optional<Object> optional3 = Optional.empty();
            if (optional.isPresent()) {
                level.playSound(player, blockpos, SoundEvents.AXE_STRIP, SoundSource.BLOCKS, 1.0f, 1.0f);
                optional3 = optional;
            } else if (optional1.isPresent()) {
                level.playSound(player, blockpos, SoundEvents.AXE_SCRAPE, SoundSource.BLOCKS, 1.0f, 1.0f);
                level.levelEvent(player, 3005, blockpos, 0);
                optional3 = optional1;
            } else if (optional2.isPresent()) {
                level.playSound(player, blockpos, SoundEvents.AXE_WAX_OFF, SoundSource.BLOCKS, 1.0f, 1.0f);
                level.levelEvent(player, 3004, blockpos, 0);
                optional3 = optional2;
            }
            if (optional3.isPresent()) {
                if (player instanceof ServerPlayer) {
                    CriteriaTriggers.ITEM_USED_ON_BLOCK.trigger((ServerPlayer)player, blockpos, itemstack);
                }
                level.setBlock(blockpos, (BlockState)optional3.get(), 11);
                if (player != null) {
                    itemstack.hurtAndBreak(1, (LivingEntity)player, EquipmentSlot.MAINHAND);
                }
                return InteractionResult.sidedSuccess((boolean)level.isClientSide);
            }
            if (context.getClickedFace() == Direction.DOWN) {
                return InteractionResult.PASS;
            }
            BlockState blockstate1 = blockstate.getToolModifiedState(context, ItemAbilities.SHOVEL_FLATTEN, false);
            BlockState blockstate2 = null;
            if (blockstate1 != null && level.isEmptyBlock(blockpos.above())) {
                level.playSound(player, blockpos, SoundEvents.SHOVEL_FLATTEN, SoundSource.BLOCKS, 1.0f, 1.0f);
                blockstate2 = blockstate1;
            } else if (blockstate.getBlock() instanceof CampfireBlock && ((Boolean)blockstate.getValue((Property)CampfireBlock.LIT)).booleanValue()) {
                if (!level.isClientSide()) {
                    level.levelEvent((Player)null, 1009, blockpos, 0);
                }
                CampfireBlock.dowse((Entity)context.getPlayer(), (LevelAccessor)level, (BlockPos)blockpos, (BlockState)blockstate);
                blockstate2 = (BlockState)blockstate.setValue((Property)CampfireBlock.LIT, (Comparable)Boolean.valueOf(false));
            }
            if (blockstate2 != null) {
                if (!level.isClientSide) {
                    level.setBlock(blockpos, blockstate2, 11);
                    if (player != null) {
                        context.getItemInHand().hurtAndBreak(1, (LivingEntity)player, EquipmentSlot.MAINHAND);
                    }
                }
                return InteractionResult.sidedSuccess((boolean)level.isClientSide);
            }
            stack.setDamageValue(0);
            return InteractionResult.SUCCESS;
        }
        if (context.getLevel().getBlockState(pos).getBlock() == Blocks.TORCH || context.getLevel().getBlockState(pos).getBlock() == Blocks.WALL_TORCH) {
            return InteractionResult.FAIL;
        }
        Boolean isWallTorch = false;
        switch (context.getClickedFace()) {
            case UP: {
                torchPos = new BlockPos(pos.getX(), pos.getY() + 1, pos.getZ());
                break;
            }
            case NORTH: {
                torchPos = new BlockPos(pos.getX(), pos.getY(), pos.getZ() - 1);
                isWallTorch = true;
                break;
            }
            case SOUTH: {
                torchPos = new BlockPos(pos.getX(), pos.getY(), pos.getZ() + 1);
                isWallTorch = true;
                break;
            }
            case WEST: {
                torchPos = new BlockPos(pos.getX() - 1, pos.getY(), pos.getZ());
                isWallTorch = true;
                break;
            }
            case EAST: {
                torchPos = new BlockPos(pos.getX() + 1, pos.getY(), pos.getZ());
                isWallTorch = true;
                break;
            }
            default: {
                return InteractionResult.FAIL;
            }
        }
        if (context.getLevel().getBlockState(torchPos).isAir() || context.getLevel().getBlockState(torchPos).getFluidState().isSource()) {
            if (blockstate.isRedstoneConductor((BlockGetter)world, pos) || blockstate.getBlock() instanceof FenceBlock) {
                if (isWallTorch.booleanValue()) {
                    context.getLevel().setBlockAndUpdate(torchPos, (BlockState)Blocks.WALL_TORCH.defaultBlockState().setValue((Property)HorizontalDirectionalBlock.FACING, (Comparable)context.getClickedFace()));
                    context.getLevel().playSound(null, context.getPlayer().blockPosition(), SoundEvents.WOOD_PLACE, SoundSource.NEUTRAL, 8.0f, (float)((double)0.7f + Math.random() * 0.3));
                } else {
                    context.getLevel().setBlockAndUpdate(torchPos, Blocks.TORCH.defaultBlockState());
                    context.getLevel().playSound(null, context.getPlayer().blockPosition(), SoundEvents.WOOD_PLACE, SoundSource.NEUTRAL, 8.0f, (float)((double)0.7f + Math.random() * 0.3));
                }
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.FAIL;
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(Level world, Player player, @NotNull InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (!world.isClientSide && player.isShiftKeyDown()) {
            EnableUtil.changeStatus(stack);
            player.displayClientMessage((Component)Component.translatable((String)"item.gobber2.gobber2_paxel_stars.line4", (Object[])new Object[]{EnableUtil.isEnabled(stack)}).withStyle(ChatFormatting.RED), true);
            return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)player.getItemInHand(hand));
        }
        return super.use(world, player, hand);
    }

    public void onCraftedBy(@NotNull ItemStack stack, @NotNull Level worldIn, @NotNull Player playerIn) {
        if (ConfigJankson.getConfig().endToolsUnbreakable) {
            stack.set(DataComponents.UNBREAKABLE, (Object)new Unbreakable(true));
        }
    }

    @Override
    public boolean isBookEnchantable(ItemStack stack, ItemStack book) {
        return true;
    }

    @Override
    public void appendHoverText(@NotNull ItemStack stack, @NotNull Item.TooltipContext context, @NotNull List<Component> tooltip, @NotNull TooltipFlag flagIn) {
        super.appendHoverText(stack, context, tooltip, flagIn);
        tooltip.add((Component)Component.translatable((String)"item.gobber2.gobber2_paxel_stars.line2").withStyle(ChatFormatting.YELLOW));
        tooltip.add((Component)Component.translatable((String)"item.gobber2.gobber2_paxel_stars.line3").withStyle(ChatFormatting.YELLOW));
        tooltip.add((Component)Component.translatable((String)"item.gobber2.gobber2_paxel_stars.line4", (Object[])new Object[]{EnableUtil.isEnabled(stack)}).withStyle(ChatFormatting.RED));
        tooltip.add((Component)Component.translatable((String)"item.gobber2.gobber2_paxel_stars.line5").withStyle(ChatFormatting.LIGHT_PURPLE));
    }
}

