/*
 * Decompiled with CFR 0.152.
 */
package com.kwpugh.gobber2.items.tools.endtools;

import com.kwpugh.gobber2.config.ConfigJankson;
import com.kwpugh.gobber2.init.ItemInit;
import com.kwpugh.gobber2.util.EnableUtil;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ArrowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.Unbreakable;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class SwordEndSniper
extends SwordItem {
    public SwordEndSniper(Tier tier, Item.Properties builder) {
        super(tier, builder);
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(@NotNull Level level, Player player, @NotNull InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        ItemStack offHand = player.getOffhandItem();
        Item stack2 = offHand.getItem().asItem();
        if (stack2 != ItemInit.DRAGON_STAR.get()) {
            player.getCooldowns().addCooldown((Item)this, ConfigJankson.getConfig().sniperSwordCooldown);
        }
        if (!ConfigJankson.getConfig().enableDragonArmorStarOffhand) {
            player.getCooldowns().addCooldown((Item)this, ConfigJankson.getConfig().sniperSwordCooldown);
        }
        if (!level.isClientSide) {
            ArrowItem itemarrow = (ArrowItem)Items.ARROW;
            AbstractArrow entityarrow = itemarrow.createArrow(level, new ItemStack((ItemLike)Items.ARROW), (LivingEntity)player, stack);
            float arrowVelocity = ConfigJankson.getConfig().sniperSpeed;
            entityarrow.shootFromRotation((Entity)player, player.xRotO, player.yRotO, 0.0f, arrowVelocity, ConfigJankson.getConfig().sniperDivergence);
            entityarrow.setBaseDamage((double)ConfigJankson.getConfig().sniperBaseDamage);
            entityarrow.setCritArrow(ConfigJankson.getConfig().sniperAlwaysCriticalHit);
            level.addFreshEntity((Entity)entityarrow);
            entityarrow.pickup = AbstractArrow.Pickup.DISALLOWED;
            return new InteractionResultHolder(InteractionResult.PASS, (Object)player.getItemInHand(hand));
        }
        return super.use(level, player, hand);
    }

    public void onCraftedBy(@NotNull ItemStack stack, @NotNull Level worldIn, @NotNull Player playerIn) {
        if (ConfigJankson.getConfig().endToolsUnbreakable) {
            stack.set(DataComponents.UNBREAKABLE, (Object)new Unbreakable(true));
        }
    }

    public boolean isBookEnchantable(@NotNull ItemStack stack, @NotNull ItemStack book) {
        return true;
    }

    public void appendHoverText(@NotNull ItemStack stack, @NotNull Item.TooltipContext context, @NotNull List<Component> tooltip, @NotNull TooltipFlag flagIn) {
        super.appendHoverText(stack, context, tooltip, flagIn);
        tooltip.add((Component)Component.translatable((String)"item.gobber2.gobber2_sword_sniper.line1").withStyle(ChatFormatting.GREEN));
        tooltip.add((Component)Component.translatable((String)"item.gobber2.gobber2_sword_sniper.line2").withStyle(ChatFormatting.YELLOW));
        tooltip.add((Component)Component.translatable((String)"item.gobber2.gobber2_sword_sniper.line3").withStyle(ChatFormatting.YELLOW));
        tooltip.add((Component)Component.translatable((String)"item.gobber2.gobber2_sword_sniper.line4", (Object[])new Object[]{EnableUtil.isEnabled(stack)}).withStyle(ChatFormatting.RED));
        tooltip.add((Component)Component.translatable((String)"item.gobber2.gobber2_sword_sniper.line5").withStyle(ChatFormatting.LIGHT_PURPLE));
    }
}

