/*
 * Decompiled with CFR 0.152.
 */
package com.kwpugh.gobber2.items.tools.endtools;

import com.kwpugh.gobber2.config.ConfigJankson;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.Unbreakable;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class SwordEndTraveler
extends SwordItem {
    public SwordEndTraveler(Tier tier, Item.Properties builder) {
        super(tier, builder);
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(@NotNull Level world, @NotNull Player entity, @NotNull InteractionHand hand) {
        InteractionResultHolder result = super.use(world, entity, hand);
        Vec3 look = entity.getLookAngle().normalize();
        double lookX = look.x;
        double lookY = look.y;
        double lookZ = look.z;
        if (entity.onGround() && !entity.isCrouching()) {
            entity.setDeltaMovement(lookX * 0.0, lookY * 4.5, lookZ * 0.0);
        }
        if (!entity.onGround()) {
            entity.push(lookX * 0.6, lookY * 0.6, lookZ * 0.6);
        }
        return result;
    }

    public void onCraftedBy(@NotNull ItemStack stack, @NotNull Level worldIn, @NotNull Player playerIn) {
        if (ConfigJankson.getConfig().endToolsUnbreakable) {
            stack.set(DataComponents.UNBREAKABLE, (Object)new Unbreakable(true));
        }
    }

    public boolean isBookEnchantable(@NotNull ItemStack stack, @NotNull ItemStack book) {
        return true;
    }

    public void appendHoverText(@NotNull ItemStack stack, @NotNull Item.TooltipContext context, @NotNull List<Component> tooltip, @NotNull TooltipFlag flagIn) {
        super.appendHoverText(stack, context, tooltip, flagIn);
        tooltip.add((Component)Component.translatable((String)"item.gobber2.gobber2_sword_traveler.line1").withStyle(ChatFormatting.GREEN));
        tooltip.add((Component)Component.translatable((String)"item.gobber2.gobber2_sword_traveler.line2").withStyle(ChatFormatting.YELLOW));
    }
}

