/*
 * Decompiled with CFR 0.152.
 */
package com.kwpugh.gobber2.util;

import com.kwpugh.gobber2.util.PlayerEquipUtil;
import java.util.function.Predicate;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.client.event.ComputeFovModifierEvent;

public final class BowUtils {
    public static void setupBowFov(ComputeFovModifierEvent event, Predicate<Item> predicate, float zoomValue) {
        float oldFOV = event.getFovModifier();
        float newFOV = 1.0f;
        ItemStack stack = event.getPlayer().getMainHandItem();
        if (stack.isEmpty()) {
            return;
        }
        Item item = stack.getItem();
        int ticks = event.getPlayer().getTicksUsingItem();
        if (item instanceof BowItem && PlayerEquipUtil.hasArrowInInventory(event.getPlayer())) {
            float zoom = 1.0f;
            if (!predicate.test(item)) {
                return;
            }
            zoom = zoomValue;
            newFOV = oldFOV - (float)ticks * zoom / 20.0f;
            if (newFOV < oldFOV - zoom) {
                newFOV = oldFOV - zoom;
            }
            event.setNewFovModifier(newFOV);
        }
    }

    public static void setupBowModelProperties(Item item) {
        ItemProperties.register((Item)item, (ResourceLocation)ResourceLocation.parse((String)"pull"), (itemStack, world, livingEntity, seed) -> {
            if (livingEntity == null) {
                return 0.0f;
            }
            return livingEntity.getUseItem() != itemStack ? 0.0f : (float)(itemStack.getUseDuration(livingEntity) - livingEntity.getUseItemRemainingTicks()) / 20.0f;
        });
        ItemProperties.register((Item)item, (ResourceLocation)ResourceLocation.parse((String)"pulling"), (itemStack, world, livingEntity, seed) -> livingEntity != null && livingEntity.isUsingItem() && livingEntity.getUseItem() == itemStack ? 1.0f : 0.0f);
    }
}

