/*
 * Decompiled with CFR 0.152.
 */
package com.kwpugh.gobber2.util;

import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ambient.Bat;
import net.minecraft.world.entity.animal.AbstractGolem;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.FlyingAnimal;
import net.minecraft.world.entity.animal.ShoulderRidingEntity;
import net.minecraft.world.entity.animal.WaterAnimal;
import net.minecraft.world.entity.animal.allay.Allay;
import net.minecraft.world.entity.animal.camel.Camel;
import net.minecraft.world.entity.boss.enderdragon.EnderDragon;
import net.minecraft.world.entity.boss.wither.WitherBoss;
import net.minecraft.world.entity.monster.ElderGuardian;
import net.minecraft.world.entity.monster.Ghast;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.Phantom;
import net.minecraft.world.entity.monster.Slime;
import net.minecraft.world.entity.monster.breeze.Breeze;
import net.minecraft.world.entity.monster.warden.Warden;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.npc.WanderingTrader;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.common.Tags;

public class CatcherUtil {
    public static boolean hasEntity(ItemStack stack) {
        CompoundTag entityTag;
        CustomData customData = (CustomData)stack.get(DataComponents.CUSTOM_DATA);
        return customData != null && (entityTag = customData.copyTag()).contains("id");
    }

    public static String getEntityId(ItemStack stack) {
        CompoundTag entityTag;
        CustomData customData = (CustomData)stack.get(DataComponents.CUSTOM_DATA);
        String entityName = "None";
        if (customData != null && (entityTag = customData.copyTag()).contains("id")) {
            entityName = entityTag.getString("id");
        }
        return entityName;
    }

    public static void catchPassiveMob(Player player, Entity entity, ItemStack stack, InteractionHand hand) {
        EntityType entityType = entity.getType();
        boolean disallowed = entityType.is(Tags.EntityTypes.CAPTURING_NOT_SUPPORTED);
        if (disallowed) {
            return;
        }
        if (entity instanceof Player || !entity.isAlive()) {
            return;
        }
        if (entity instanceof Animal || entity instanceof Allay || entity instanceof Camel || entity instanceof WaterAnimal || entity instanceof FlyingAnimal || entity instanceof TamableAnimal || entity instanceof AbstractGolem || entity instanceof ShoulderRidingEntity || entity instanceof Villager || entity instanceof WanderingTrader || entity instanceof Bat) {
            CatcherUtil.saveEntityToStack(entity, stack);
        }
    }

    public static void catchHostileMob(Player player, Entity entity, ItemStack stack, InteractionHand hand) {
        EntityType entityType = entity.getType();
        boolean disallowed = entityType.is(Tags.EntityTypes.CAPTURING_NOT_SUPPORTED);
        if (disallowed) {
            return;
        }
        if (entity instanceof Player || !entity.isAlive()) {
            return;
        }
        if (entity instanceof WitherBoss || entity instanceof EnderDragon || entity instanceof Warden || entity instanceof Breeze || entity instanceof ElderGuardian) {
            return;
        }
        if (entity instanceof Monster || entity instanceof Slime || entity instanceof Ghast || entity instanceof Phantom) {
            CatcherUtil.saveEntityToStack(entity, stack);
        }
    }

    public static void saveEntityToStack(Entity entity, ItemStack stack) {
        if (entity.level().isClientSide) {
            return;
        }
        CompoundTag entityTag = new CompoundTag();
        String id = entity.getEncodeId();
        if (id != null) {
            entityTag.putString("id", entity.getEncodeId());
            entity.saveWithoutId(entityTag);
            CustomData customData = CustomData.of((CompoundTag)entityTag);
            stack.set(DataComponents.CUSTOM_DATA, (Object)customData);
            entity.discard();
        }
    }

    public static void respawnEntity(UseOnContext context, ItemStack stack) {
        if (context.getLevel().isClientSide) {
            return;
        }
        BlockPos pos = context.getClickedPos().relative(context.getClickedFace());
        CustomData customData = (CustomData)stack.get(DataComponents.CUSTOM_DATA);
        if (customData == null) {
            return;
        }
        CompoundTag entityTag = customData.copyTag();
        Entity entity = EntityType.loadEntityRecursive((CompoundTag)entityTag, (Level)context.getLevel(), a -> a);
        if (entity != null) {
            entity.setPos((double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5);
            context.getLevel().addFreshEntity(entity);
            CompoundTag freshTag = new CompoundTag();
            customData = CustomData.of((CompoundTag)freshTag);
            stack.set(DataComponents.CUSTOM_DATA, (Object)customData);
        }
    }
}

