/*
 * Decompiled with CFR 0.152.
 */
package com.kwpugh.gobber2.util;

import com.kwpugh.gobber2.config.ConfigJankson;
import com.kwpugh.gobber2.init.ItemInit;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.PlayerEnderChestContainer;
import net.minecraft.world.item.ArrowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public final class PlayerEquipUtil {
    public static boolean isWearingFullGobberArmor(Player player) {
        ItemStack head = player.getItemBySlot(EquipmentSlot.HEAD);
        ItemStack chest = player.getItemBySlot(EquipmentSlot.CHEST);
        ItemStack legs = player.getItemBySlot(EquipmentSlot.LEGS);
        ItemStack feet = player.getItemBySlot(EquipmentSlot.FEET);
        return head.getItem() == ItemInit.GOBBER2_HELMET.get() && chest.getItem() == ItemInit.GOBBER2_CHESTPLATE.get() && legs.getItem() == ItemInit.GOBBER2_LEGGINGS.get() && feet.getItem() == ItemInit.GOBBER2_BOOTS.get();
    }

    public static boolean isWearingFullNetherArmor(Player player) {
        ItemStack head = player.getItemBySlot(EquipmentSlot.HEAD);
        ItemStack chest = player.getItemBySlot(EquipmentSlot.CHEST);
        ItemStack legs = player.getItemBySlot(EquipmentSlot.LEGS);
        ItemStack feet = player.getItemBySlot(EquipmentSlot.FEET);
        return head.getItem() == ItemInit.GOBBER2_HELMET_NETHER.get() && chest.getItem() == ItemInit.GOBBER2_CHESTPLATE_NETHER.get() && legs.getItem() == ItemInit.GOBBER2_LEGGINGS_NETHER.get() && feet.getItem() == ItemInit.GOBBER2_BOOTS_NETHER.get();
    }

    public static boolean isWearingFullEndArmor(Player player) {
        ItemStack head = player.getItemBySlot(EquipmentSlot.HEAD);
        ItemStack chest = player.getItemBySlot(EquipmentSlot.CHEST);
        ItemStack legs = player.getItemBySlot(EquipmentSlot.LEGS);
        ItemStack feet = player.getItemBySlot(EquipmentSlot.FEET);
        return head.getItem() == ItemInit.GOBBER2_HELMET_END.get() && chest.getItem() == ItemInit.GOBBER2_CHESTPLATE_END.get() && legs.getItem() == ItemInit.GOBBER2_LEGGINGS_END.get() && feet.getItem() == ItemInit.GOBBER2_BOOTS_END.get();
    }

    public static boolean isWearingFullDragonArmor(Player player) {
        ItemStack head = player.getItemBySlot(EquipmentSlot.HEAD);
        ItemStack chest = player.getItemBySlot(EquipmentSlot.CHEST);
        ItemStack legs = player.getItemBySlot(EquipmentSlot.LEGS);
        ItemStack feet = player.getItemBySlot(EquipmentSlot.FEET);
        return head.getItem() == ItemInit.GOBBER2_HELMET_DRAGON.get() && chest.getItem() == ItemInit.GOBBER2_CHESTPLATE_DRAGON.get() && legs.getItem() == ItemInit.GOBBER2_LEGGINGS_DRAGON.get() && feet.getItem() == ItemInit.GOBBER2_BOOTS_DRAGON.get();
    }

    public static boolean hasWaterBreathing(Player player) {
        if (player.level().isClientSide) {
            return false;
        }
        if (PlayerEquipUtil.hasItemInInventory(player, (Item)ItemInit.GOBBER2_MEDALLION_BREATHING.get()) || PlayerEquipUtil.hasItemInEnderchest(player, (Item)ItemInit.GOBBER2_MEDALLION_BREATHING.get())) {
            return true;
        }
        if (ConfigJankson.getConfig().enableGobberArmorWaterBreathing && PlayerEquipUtil.isWearingFullGobberArmor(player)) {
            return true;
        }
        if (ConfigJankson.getConfig().enableEndArmorWaterBreathing && PlayerEquipUtil.isWearingFullEndArmor(player)) {
            return true;
        }
        return ConfigJankson.getConfig().enableDragonArmorWaterBreathing && PlayerEquipUtil.isWearingFullDragonArmor(player);
    }

    public static boolean hasFireProtection(Player player) {
        if (player.level().isClientSide) {
            return false;
        }
        if (PlayerEquipUtil.hasItemInInventory(player, (Item)ItemInit.GOBBER2_RING_PHOENIX.get()) || PlayerEquipUtil.hasItemInEnderchest(player, (Item)ItemInit.GOBBER2_RING_PHOENIX.get())) {
            return true;
        }
        if (ConfigJankson.getConfig().enableNetherArmorFireProtection && PlayerEquipUtil.isWearingFullNetherArmor(player)) {
            return true;
        }
        if (ConfigJankson.getConfig().enableEndArmorFireProtection && PlayerEquipUtil.isWearingFullEndArmor(player)) {
            return true;
        }
        return ConfigJankson.getConfig().enableDragonArmorFireProtection && PlayerEquipUtil.isWearingFullDragonArmor(player);
    }

    public static boolean hasFallProtection(Player player) {
        if (player.level().isClientSide) {
            return false;
        }
        ItemStack mainHand = player.getMainHandItem();
        ItemStack offHand = player.getOffhandItem();
        if (mainHand.getItem() == ItemInit.GOBBER2_RING_ASCENT.get() || offHand.getItem() == ItemInit.GOBBER2_RING_ASCENT.get() || PlayerEquipUtil.hasItemInEnderchest(player, (Item)ItemInit.GOBBER2_RING_ASCENT.get())) {
            return true;
        }
        if (ConfigJankson.getConfig().enableEndArmorNoFallDamage && PlayerEquipUtil.isWearingFullEndArmor(player)) {
            return true;
        }
        return ConfigJankson.getConfig().enableDragonArmorNoFallDamage && PlayerEquipUtil.isWearingFullDragonArmor(player);
    }

    public static boolean hasBlastProtection(Player player) {
        if (player.level().isClientSide) {
            return false;
        }
        if (ConfigJankson.getConfig().enableEndArmorBlastProtection && PlayerEquipUtil.isWearingFullEndArmor(player)) {
            return true;
        }
        return ConfigJankson.getConfig().enableDragonArmorBlastProtection && PlayerEquipUtil.isWearingFullDragonArmor(player);
    }

    public static boolean hasVoidProtection(Player player) {
        if (player.level().isClientSide) {
            return false;
        }
        return ConfigJankson.getConfig().enableDragonArmorVoidProtection && PlayerEquipUtil.isWearingFullDragonArmor(player);
    }

    public static boolean hasStealth(Player player) {
        ItemStack mainHand = player.getMainHandItem();
        ItemStack offHand = player.getOffhandItem();
        return mainHand.getItem() == ItemInit.GOBBER2_RING_STEALTH.get() && offHand.isEmpty();
    }

    public static boolean hasStealthRingInHand(Player player) {
        ItemStack mainHand = player.getMainHandItem();
        ItemStack offHand = player.getOffhandItem();
        return mainHand.getItem() == ItemInit.GOBBER2_RING_STEALTH.get() && offHand.isEmpty();
    }

    public static boolean hasArrowInInventory(Player player) {
        Inventory inv = player.getInventory();
        for (int slot = 0; slot < inv.getContainerSize(); ++slot) {
            ItemStack stack = inv.getItem(slot);
            if (!(stack.getItem() instanceof ArrowItem)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasItemInInventory(Player player, Item item) {
        Inventory inv = player.getInventory();
        for (int slot = 0; slot < inv.getContainerSize(); ++slot) {
            ItemStack stack = inv.getItem(slot);
            if (stack.getItem() != item) continue;
            return true;
        }
        return false;
    }

    public static ItemStack getItemInInventory(Player player, Item item) {
        Inventory inv = player.getInventory();
        for (int slot = 0; slot < inv.getContainerSize(); ++slot) {
            ItemStack stack = inv.getItem(slot);
            if (stack.getItem() != item) continue;
            return stack;
        }
        return ItemStack.EMPTY;
    }

    public static boolean hasItemInEnderchest(Player player, Item item) {
        PlayerEnderChestContainer end_inv = player.getEnderChestInventory();
        for (int slot = 0; slot < end_inv.getContainerSize(); ++slot) {
            ItemStack stack = end_inv.getItem(slot);
            if (stack.getItem() != item) continue;
            return true;
        }
        return false;
    }

    public static ItemStack getItemInEnderchest(Player player, Item item) {
        PlayerEnderChestContainer end_inv = player.getEnderChestInventory();
        for (int slot = 0; slot < end_inv.getContainerSize(); ++slot) {
            ItemStack stack = end_inv.getItem(slot);
            if (stack.getItem() != item) continue;
            return stack;
        }
        return ItemStack.EMPTY;
    }
}

