/*
 * Decompiled with CFR 0.152.
 */
package com.kwpugh.gobber2.world;

import com.kwpugh.gobber2.blocks.BlockOreEnd;
import com.kwpugh.gobber2.blocks.BlockOreGobber;
import com.kwpugh.gobber2.blocks.BlockOreNether;
import com.kwpugh.gobber2.init.BlockInit;
import java.util.List;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.OreConfiguration;
import net.minecraft.world.level.levelgen.structure.templatesystem.BlockMatchTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.RuleTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.TagMatchTest;

public class ModConfiguredFeatures {
    public static final ResourceKey<ConfiguredFeature<?, ?>> OVERWORLD_GOBBER_ORE_KEY = ModConfiguredFeatures.registerKey("gobber_ore_configured");
    public static final ResourceKey<ConfiguredFeature<?, ?>> NETHER_GOBBER_NETHER_ORE_KEY = ModConfiguredFeatures.registerKey("nether_gobber_nether_ore_configured");
    public static final ResourceKey<ConfiguredFeature<?, ?>> END_GOBBER_END_ORE_KEY = ModConfiguredFeatures.registerKey("end_gobber_end_ore_configured");
    public static final ResourceKey<ConfiguredFeature<?, ?>> OVERWORLD_LUCKY_BLOCK_KEY = ModConfiguredFeatures.registerKey("lucky_block_configured");
    public static final ResourceKey<ConfiguredFeature<?, ?>> NETHER_LUCKY_BLOCK_KEY = ModConfiguredFeatures.registerKey("nether_lucky_block_configured");
    public static final ResourceKey<ConfiguredFeature<?, ?>> END_LUCKY_BLOCK_KEY = ModConfiguredFeatures.registerKey("end_lucky_block_configured");

    public static void bootstrap(BootstrapContext<ConfiguredFeature<?, ?>> context) {
        TagMatchTest stoneReplaceable = new TagMatchTest(BlockTags.STONE_ORE_REPLACEABLES);
        TagMatchTest deepslateReplaceables = new TagMatchTest(BlockTags.DEEPSLATE_ORE_REPLACEABLES);
        TagMatchTest netherReplaceables = new TagMatchTest(BlockTags.BASE_STONE_NETHER);
        BlockMatchTest theEndReplaceables = new BlockMatchTest(Blocks.END_STONE);
        List<OreConfiguration.TargetBlockState> overworldGobberOres = List.of(OreConfiguration.target((RuleTest)stoneReplaceable, (BlockState)((BlockOreGobber)((Object)BlockInit.GOBBER2_ORE.get())).defaultBlockState()), OreConfiguration.target((RuleTest)deepslateReplaceables, (BlockState)((BlockOreGobber)((Object)BlockInit.GOBBER2_ORE_DEEPSLATE.get())).defaultBlockState()));
        List<OreConfiguration.TargetBlockState> netherGobberNetherOres = List.of(OreConfiguration.target((RuleTest)netherReplaceables, (BlockState)((BlockOreNether)((Object)BlockInit.GOBBER2_ORE_NETHER.get())).defaultBlockState()));
        List<OreConfiguration.TargetBlockState> endGobberEndOres = List.of(OreConfiguration.target((RuleTest)theEndReplaceables, (BlockState)((BlockOreEnd)((Object)BlockInit.GOBBER2_ORE_END.get())).defaultBlockState()));
        List<OreConfiguration.TargetBlockState> overworldLuckyBlocks = List.of(OreConfiguration.target((RuleTest)stoneReplaceable, (BlockState)((Block)BlockInit.GOBBER2_LUCKY_BLOCK.get()).defaultBlockState()), OreConfiguration.target((RuleTest)deepslateReplaceables, (BlockState)((Block)BlockInit.GOBBER2_LUCKY_BLOCK_DEEPSLATE.get()).defaultBlockState()));
        List<OreConfiguration.TargetBlockState> netherLuckyBlock = List.of(OreConfiguration.target((RuleTest)netherReplaceables, (BlockState)((Block)BlockInit.GOBBER2_LUCKY_BLOCK_NETHER.get()).defaultBlockState()));
        List<OreConfiguration.TargetBlockState> endLuckyBlock = List.of(OreConfiguration.target((RuleTest)theEndReplaceables, (BlockState)((Block)BlockInit.GOBBER2_LUCKY_BLOCK_END.get()).defaultBlockState()));
        ModConfiguredFeatures.register(context, OVERWORLD_GOBBER_ORE_KEY, Feature.ORE, new OreConfiguration(overworldGobberOres, 8));
        ModConfiguredFeatures.register(context, NETHER_GOBBER_NETHER_ORE_KEY, Feature.ORE, new OreConfiguration(netherGobberNetherOres, 8));
        ModConfiguredFeatures.register(context, END_GOBBER_END_ORE_KEY, Feature.ORE, new OreConfiguration(endGobberEndOres, 8));
        ModConfiguredFeatures.register(context, OVERWORLD_LUCKY_BLOCK_KEY, Feature.ORE, new OreConfiguration(overworldLuckyBlocks, 8));
        ModConfiguredFeatures.register(context, NETHER_LUCKY_BLOCK_KEY, Feature.ORE, new OreConfiguration(netherLuckyBlock, 8));
        ModConfiguredFeatures.register(context, END_LUCKY_BLOCK_KEY, Feature.ORE, new OreConfiguration(endLuckyBlock, 6));
    }

    public static ResourceKey<ConfiguredFeature<?, ?>> registerKey(String name) {
        return ResourceKey.create((ResourceKey)Registries.CONFIGURED_FEATURE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"gobber2", (String)name));
    }

    private static <FC extends FeatureConfiguration, F extends Feature<FC>> void register(BootstrapContext<ConfiguredFeature<?, ?>> context, ResourceKey<ConfiguredFeature<?, ?>> key, F feature, FC configuration) {
        context.register(key, (Object)new ConfiguredFeature(feature, configuration));
    }
}

