/*
 * Decompiled with CFR 0.152.
 */
package com.hrznstudio.emojiful;

import com.esotericsoftware.yamlbeans.YamlReader;
import com.google.gson.JsonElement;
import com.hrznstudio.emojiful.CommonClass;
import com.hrznstudio.emojiful.Constants;
import com.hrznstudio.emojiful.api.Emoji;
import com.hrznstudio.emojiful.api.EmojiCategory;
import com.hrznstudio.emojiful.api.EmojiFromTwitmoji;
import com.hrznstudio.emojiful.platform.Services;
import com.hrznstudio.emojiful.util.ProfanityFilter;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.stream.Collectors;

public class ClientEmojiHandler {
    public static final List<EmojiCategory> CATEGORIES = new ArrayList<EmojiCategory>();
    public static List<String> ALL_EMOJIS = new ArrayList<String>();
    public static HashMap<EmojiCategory, List<Emoji[]>> SORTED_EMOJIS_FOR_SELECTION = new LinkedHashMap<EmojiCategory, List<Emoji[]>>();
    public static List<Emoji> EMOJI_WITH_TEXTS = new ArrayList<Emoji>();
    public static int lineAmount;

    public static void setup() {
        new Thread(() -> {
            ClientEmojiHandler.preInitEmojis();
            ClientEmojiHandler.indexEmojis();
            Constants.LOG.info("Loaded " + Constants.EMOJI_LIST.size() + " emojis");
        }).start();
    }

    public static void indexEmojis() {
        ALL_EMOJIS = Constants.EMOJI_LIST.stream().map(emoji -> emoji.strings).flatMap(Collection::stream).collect(Collectors.toList());
        SORTED_EMOJIS_FOR_SELECTION = new LinkedHashMap<EmojiCategory, List<Emoji[]>>();
        for (EmojiCategory category : CATEGORIES) {
            ++lineAmount;
            Emoji[] array = new Emoji[9];
            int i = 0;
            Iterator iterator = ((List)Constants.EMOJI_MAP.getOrDefault(category.name(), new ArrayList())).iterator();
            while (iterator.hasNext()) {
                Emoji emoji2;
                array[i] = emoji2 = (Emoji)iterator.next();
                if (++i < array.length) continue;
                SORTED_EMOJIS_FOR_SELECTION.computeIfAbsent(category, s -> new ArrayList()).add(array);
                array = new Emoji[9];
                i = 0;
                ++lineAmount;
            }
            if (i <= 0) continue;
            SORTED_EMOJIS_FOR_SELECTION.computeIfAbsent(category, s -> new ArrayList()).add(array);
            ++lineAmount;
        }
    }

    private static void preInitEmojis() {
        if (Services.CONFIG.loadCustom()) {
            ClientEmojiHandler.loadCustomEmojis();
        }
        if (Services.CONFIG.loadTwemoji()) {
            CATEGORIES.addAll(Arrays.asList("Smileys & Emotion", "Animals & Nature", "Food & Drink", "Activities", "Travel & Places", "Objects", "Symbols", "Flags").stream().map(s -> new EmojiCategory((String)s, false)).collect(Collectors.toList()));
            ClientEmojiHandler.loadTwemojis();
        }
        if (Services.CONFIG.getProfanityFilter()) {
            ProfanityFilter.loadConfigs();
        }
    }

    private static void loadCustomEmojis() {
        try {
            YamlReader reader = new YamlReader((Reader)new StringReader(CommonClass.readStringFromURL("https://raw.githubusercontent.com/InnovativeOnlineIndustries/emojiful-assets/1.20-plus/Categories.yml")));
            ArrayList categories = (ArrayList)reader.read();
            for (String category : categories) {
                CATEGORIES.add(new EmojiCategory(category.replace(".yml", ""), false));
                List<Emoji> emojis = CommonClass.readCategory(category);
                emojis.forEach(emoji -> {
                    emoji.location = CommonClass.cleanURL(emoji.location);
                });
                emojis.forEach(emoji -> {
                    emoji.name = "custom_" + emoji.name;
                });
                Constants.EMOJI_LIST.addAll(emojis);
                Constants.EMOJI_MAP.put(category.replace(".yml", ""), emojis);
            }
        }
        catch (Exception e) {
            Constants.error = true;
            Constants.LOG.error("An exception was caught whilst loading custom emojis", (Throwable)e);
        }
    }

    public static void loadTwemojis() {
        try {
            for (JsonElement element : CommonClass.readJsonFromUrl("https://raw.githubusercontent.com/iamcal/emoji-data/master/emoji.json").getAsJsonArray()) {
                if (!element.getAsJsonObject().get("has_img_twitter").getAsBoolean()) continue;
                EmojiFromTwitmoji emoji = new EmojiFromTwitmoji();
                emoji.name = "twemojis_" + element.getAsJsonObject().get("short_name").getAsString();
                emoji.location = element.getAsJsonObject().get("image").getAsString();
                emoji.sort = element.getAsJsonObject().get("sort_order").getAsInt();
                element.getAsJsonObject().get("short_names").getAsJsonArray().forEach(jsonElement -> emoji.strings.add(":" + jsonElement.getAsString() + ":"));
                if (emoji.strings.contains(":face_with_symbols_on_mouth:")) {
                    emoji.strings.add(":swear:");
                }
                if (!element.getAsJsonObject().get("texts").isJsonNull()) {
                    element.getAsJsonObject().get("texts").getAsJsonArray().forEach(jsonElement -> emoji.texts.add(jsonElement.getAsString()));
                }
                Constants.EMOJI_MAP.computeIfAbsent(element.getAsJsonObject().get("category").getAsString(), s -> new ArrayList()).add(emoji);
                Constants.EMOJI_LIST.add(emoji);
                if (emoji.texts.size() <= 0) continue;
                EMOJI_WITH_TEXTS.add(emoji);
            }
            EMOJI_WITH_TEXTS.sort(Comparator.comparingInt(o -> o.sort));
            Constants.EMOJI_MAP.values().forEach(emojis -> emojis.sort(Comparator.comparingInt(o -> o.sort)));
        }
        catch (Exception e) {
            Constants.error = true;
            Constants.LOG.error("Emojiful found an error while loading", (Throwable)e);
        }
    }
}

