/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbfiltersystem.api.filter;

import dev.ftb.mods.ftbfiltersystem.api.FTBFilterSystemAPI;
import dev.ftb.mods.ftbfiltersystem.api.FilterException;
import dev.ftb.mods.ftbfiltersystem.api.filter.AbstractSmartFilter;
import dev.ftb.mods.ftbfiltersystem.api.filter.SmartFilter;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Function;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;

public abstract class AbstractCompoundFilter
extends AbstractSmartFilter
implements SmartFilter.Compound {
    private final List<SmartFilter> children;

    protected AbstractCompoundFilter(SmartFilter.Compound parent, List<SmartFilter> children) {
        super(parent);
        if (children.size() > this.maxChildren()) {
            throw new FilterException("Too many children! " + children.size() + " > " + this.maxChildren());
        }
        this.children = children;
    }

    public AbstractCompoundFilter(SmartFilter.Compound parent) {
        super(parent);
        this.children = new ArrayList<SmartFilter>();
    }

    @Override
    public List<SmartFilter> getChildren() {
        return this.children;
    }

    @Override
    public String toString() {
        return FTBFilterSystemAPI.modDefaultedString(this.getId()) + "(" + this.getStringArg() + ")";
    }

    @Override
    public String getStringArg() {
        return String.join((CharSequence)"", this.children.stream().map((Function<SmartFilter, String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, toString(), (Ldev/ftb/mods/ftbfiltersystem/api/filter/SmartFilter;)Ljava/lang/String;)()).toList());
    }

    @Override
    public boolean isConfigurable() {
        return false;
    }

    @Override
    public Component getDisplayName() {
        return super.getDisplayName().copy().withStyle(ChatFormatting.ITALIC).append(" \u25b6");
    }

    public static <F extends AbstractCompoundFilter> F createCompoundFilter(BiFunction<SmartFilter.Compound, List<SmartFilter>, F> creator, SmartFilter.Compound parent, String str) {
        AbstractCompoundFilter filter = (AbstractCompoundFilter)creator.apply(parent, new ArrayList());
        List<SmartFilter> children = FTBFilterSystemAPI.api().parseFilterList(filter, str);
        if (children.size() > filter.maxChildren()) {
            throw new FilterException("Too many children for " + String.valueOf(filter.getId()) + " - expected " + filter.maxChildren() + ", got " + children.size());
        }
        filter.getChildren().addAll(children);
        return (F)filter;
    }
}

