/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.customization.action.blocks;

import de.keksuccino.fancymenu.customization.action.ActionInstance;
import de.keksuccino.fancymenu.customization.action.Executable;
import de.keksuccino.fancymenu.customization.action.blocks.AbstractExecutableBlock;
import de.keksuccino.fancymenu.customization.action.blocks.GenericExecutableBlock;
import de.keksuccino.fancymenu.customization.action.blocks.statements.ElseExecutableBlock;
import de.keksuccino.fancymenu.customization.action.blocks.statements.ElseIfExecutableBlock;
import de.keksuccino.fancymenu.customization.action.blocks.statements.IfExecutableBlock;
import de.keksuccino.fancymenu.customization.action.blocks.statements.WhileExecutableBlock;
import de.keksuccino.fancymenu.util.properties.PropertyContainer;
import de.keksuccino.konkrete.input.StringUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExecutableBlockDeserializer {
    @NotNull
    public static List<AbstractExecutableBlock> deserializeAll(@NotNull PropertyContainer serialized) {
        LinkedHashMap<AbstractExecutableBlock, BlockMeta> executableBlocks = new LinkedHashMap<AbstractExecutableBlock, BlockMeta>();
        for (Map.Entry<String, String> m : serialized.getProperties().entrySet()) {
            Object childIdentifier;
            String contentRaw;
            AbstractExecutableBlock b;
            String type;
            if (!m.getKey().startsWith("[executable_block:") || !m.getKey().contains("]")) continue;
            String identifier = m.getKey().split("\\[executable_block:", 2)[1].split("]", 2)[0];
            if (!m.getKey().contains("[type:") || !(type = m.getKey().split("\\[type:", 2)[1]).contains("]") || (b = ExecutableBlockDeserializer.deserializeEmptyWithTypeAndIdentifier(serialized, type = type.split("]", 2)[0], identifier)) == null || !(contentRaw = m.getValue()).contains("[executables:") || !contentRaw.contains("]")) continue;
            BlockMeta blockMeta = new BlockMeta();
            if ((contentRaw = contentRaw.split("\\[executables:", 2)[1].split("]", 2)[0]).contains(";")) {
                blockMeta.content = Arrays.asList(StringUtils.splitLines((String)contentRaw, (String)";"));
            } else {
                blockMeta.content.add(contentRaw);
            }
            if (m.getValue().contains("[appended:") && ((String)(childIdentifier = m.getValue().split("\\[appended:", 2)[1])).contains("]")) {
                blockMeta.childIdentifier = childIdentifier = ((String)childIdentifier).split("]", 2)[0];
            }
            executableBlocks.put(b, blockMeta);
        }
        ArrayList<Object> possibleContent = new ArrayList<Object>();
        possibleContent.addAll(executableBlocks.keySet());
        possibleContent.addAll(ActionInstance.deserializeAll(serialized));
        block1: for (Map.Entry m : executableBlocks.entrySet()) {
            AbstractExecutableBlock b = (AbstractExecutableBlock)m.getKey();
            List<String> content = ((BlockMeta)m.getValue()).content;
            block2: for (String string : content) {
                for (Executable executable : possibleContent) {
                    if (!executable.getIdentifier().equals(string)) continue;
                    b.addExecutable(executable);
                    continue block2;
                }
            }
            if (((BlockMeta)m.getValue()).childIdentifier == null) continue;
            for (Executable executable : possibleContent) {
                if (!executable.getIdentifier().equals(((BlockMeta)m.getValue()).childIdentifier) || !(executable instanceof AbstractExecutableBlock)) continue;
                AbstractExecutableBlock aeb = (AbstractExecutableBlock)executable;
                b.setAppendedBlock(aeb);
                continue block1;
            }
        }
        return new ArrayList<AbstractExecutableBlock>(executableBlocks.keySet());
    }

    @Nullable
    public static AbstractExecutableBlock deserializeWithIdentifier(@NotNull PropertyContainer serialized, @NotNull String identifier) {
        for (AbstractExecutableBlock b : ExecutableBlockDeserializer.deserializeAll(serialized)) {
            if (!b.identifier.equals(identifier)) continue;
            return b;
        }
        return null;
    }

    @Nullable
    public static AbstractExecutableBlock deserializeEmptyWithTypeAndIdentifier(@NotNull PropertyContainer serialized, @NotNull String type, @NotNull String identifier) {
        if (type.equals("generic")) {
            return GenericExecutableBlock.deserializeEmptyWithIdentifier(serialized, identifier);
        }
        if (type.equals("if")) {
            return IfExecutableBlock.deserializeEmptyWithIdentifier(serialized, identifier);
        }
        if (type.equals("else-if")) {
            return ElseIfExecutableBlock.deserializeEmptyWithIdentifier(serialized, identifier);
        }
        if (type.equals("else")) {
            return ElseExecutableBlock.deserializeEmptyWithIdentifier(serialized, identifier);
        }
        if (type.equals("while")) {
            return WhileExecutableBlock.deserializeEmptyWithIdentifier(serialized, identifier);
        }
        return null;
    }

    protected static class BlockMeta {
        @NotNull
        protected List<String> content = new ArrayList<String>();
        @Nullable
        protected String childIdentifier;

        protected BlockMeta() {
        }
    }
}

