/*
 * Decompiled with CFR 0.152.
 */
package dev.electrolyte.matc.items;

import com.blakebr0.cucumber.item.BaseReusableItem;
import dev.electrolyte.matc.config.MATCModConfig;
import java.util.List;
import java.util.function.Function;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.Enchantments;
import net.neoforged.fml.ModList;
import net.neoforged.neoforge.common.ModConfigSpec;
import net.neoforged.neoforge.registries.DeferredHolder;

public class BaseTieredCrystalItem
extends BaseReusableItem {
    private ModConfigSpec.IntValue uses;
    private final String tier;
    private ModConfigSpec.BooleanValue durabilityEnabled;

    public BaseTieredCrystalItem(ModConfigSpec.IntValue uses, String tier, ModConfigSpec.BooleanValue durabilityEnabled, Function<Item.Properties, Item.Properties> properties) {
        super(((Integer)uses.getDefault()).intValue(), properties);
        this.uses = uses;
        this.tier = tier;
        this.durabilityEnabled = durabilityEnabled;
    }

    public boolean isRepairable(ItemStack stack) {
        return false;
    }

    public int getMaxDamage(ItemStack stack) {
        return (Integer)this.uses.get();
    }

    public boolean isBarVisible(ItemStack stack) {
        return false;
    }

    public ItemStack getCraftingRemainingItem(ItemStack stack) {
        ItemStack copy = stack.copy();
        if (!((Boolean)this.durabilityEnabled.get()).booleanValue()) {
            return copy;
        }
        int unbreakingLevel = stack.getEnchantmentLevel((Holder)DeferredHolder.create((ResourceKey)Enchantments.UNBREAKING));
        if (Math.random() * 100.0 < 100.0 / ((double)unbreakingLevel + 1.0)) {
            copy.setDamageValue(stack.getDamageValue() + 1);
        }
        return copy.getDamageValue() >= copy.getMaxDamage() ? ItemStack.EMPTY : copy;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> list, TooltipFlag flag) {
        if (((Boolean)MATCModConfig.UPGRADE_TOOLTIP.get()).booleanValue()) {
            MutableComponent tierTooltip = Component.translatable((String)(String.valueOf(ChatFormatting.GRAY) + this.tier));
            list.add((Component)tierTooltip);
            if (this.tier.contains("Insanium") && !ModList.get().isLoaded("mysticalagradditions")) {
                list.remove(tierTooltip);
            }
        }
        if (((Boolean)MATCModConfig.USES_TOOLTIP.get()).booleanValue()) {
            String damage = (Boolean)this.durabilityEnabled.get() != false ? String.valueOf(stack.getMaxDamage() - this.getDamage(stack)) : "Unlimited";
            list.add((Component)Component.translatable((String)(String.valueOf(ChatFormatting.GRAY) + "Uses Left: " + String.valueOf(ChatFormatting.RED) + damage)));
        }
    }
}

