/*
 * Decompiled with CFR 0.152.
 */
package thelm.packageddraconic.block;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DirectionalBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import thelm.packagedauto.block.BaseBlock;
import thelm.packagedauto.block.entity.BaseBlockEntity;
import thelm.packageddraconic.block.entity.MarkedInjectorBlockEntity;
import thelm.packageddraconic.block.entity.PackagedDraconicBlockEntities;

public class MarkedInjectorBlock
extends BaseBlock {
    public static final VoxelShape SHAPE_DOWN = MarkedInjectorBlock.box((double)1.0, (double)6.0, (double)1.0, (double)15.0, (double)16.0, (double)15.0);
    public static final VoxelShape SHAPE_UP = MarkedInjectorBlock.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)10.0, (double)15.0);
    public static final VoxelShape SHAPE_NORTH = MarkedInjectorBlock.box((double)1.0, (double)1.0, (double)6.0, (double)15.0, (double)15.0, (double)16.0);
    public static final VoxelShape SHAPE_SOUTH = MarkedInjectorBlock.box((double)1.0, (double)1.0, (double)0.0, (double)15.0, (double)15.0, (double)10.0);
    public static final VoxelShape SHAPE_WEST = MarkedInjectorBlock.box((double)6.0, (double)1.0, (double)1.0, (double)16.0, (double)15.0, (double)15.0);
    public static final VoxelShape SHAPE_EAST = MarkedInjectorBlock.box((double)0.0, (double)1.0, (double)1.0, (double)10.0, (double)15.0, (double)15.0);
    public final int tier;

    public MarkedInjectorBlock(int tier) {
        super(BlockBehaviour.Properties.of().strength(10.0f, 15.0f).noOcclusion().mapColor(MapColor.METAL).sound(SoundType.METAL));
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)DirectionalBlock.FACING, (Comparable)Direction.UP));
        this.tier = tier;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{DirectionalBlock.FACING});
    }

    public MarkedInjectorBlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return (MarkedInjectorBlockEntity)((BlockEntityType)PackagedDraconicBlockEntities.MARKED_INJECTOR.get()).create(pos, state);
    }

    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> blockEntityType) {
        return BaseBlockEntity::tick;
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)this.defaultBlockState().setValue((Property)DirectionalBlock.FACING, (Comparable)context.getNearestLookingDirection().getOpposite());
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        Direction facing = (Direction)state.getValue((Property)DirectionalBlock.FACING);
        return switch (facing) {
            case Direction.DOWN -> SHAPE_DOWN;
            case Direction.UP -> SHAPE_UP;
            case Direction.NORTH -> SHAPE_NORTH;
            case Direction.SOUTH -> SHAPE_SOUTH;
            case Direction.WEST -> SHAPE_WEST;
            case Direction.EAST -> SHAPE_EAST;
            default -> super.getShape(state, level, pos, context);
        };
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        return InteractionResult.PASS;
    }
}

