/*
 * Decompiled with CFR 0.152.
 */
package thelm.packageddraconic.recipe;

import com.brandon3055.draconicevolution.api.DraconicAPI;
import com.brandon3055.draconicevolution.api.crafting.IFusionRecipe;
import com.brandon3055.draconicevolution.api.crafting.StackIngredient;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.common.crafting.ICustomIngredient;
import org.apache.commons.lang3.ArrayUtils;
import thelm.packagedauto.api.IPackagePattern;
import thelm.packagedauto.api.IPackageRecipeInfo;
import thelm.packagedauto.api.IPackageRecipeType;
import thelm.packagedauto.util.MiscHelper;
import thelm.packagedauto.util.PackagePattern;
import thelm.packageddraconic.inventory.FakeFusionInventory;
import thelm.packageddraconic.recipe.FusionPackageRecipeType;
import thelm.packageddraconic.recipe.IFusionPackageRecipeInfo;

public class FusionPackageRecipeInfo
implements IFusionPackageRecipeInfo {
    public static final MapCodec<FusionPackageRecipeInfo> MAP_CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ResourceLocation.CODEC.fieldOf("id").forGetter(FusionPackageRecipeInfo::getRecipeId), (App)ItemStack.OPTIONAL_CODEC.orElse((Object)ItemStack.EMPTY).fieldOf("core").forGetter(FusionPackageRecipeInfo::getCoreInput), (App)ItemStack.OPTIONAL_CODEC.orElse((Object)ItemStack.EMPTY).sizeLimitedListOf(54).fieldOf("injector").forGetter(FusionPackageRecipeInfo::getInjectorInputs)).apply((Applicative)instance, FusionPackageRecipeInfo::new));
    public static final Codec<FusionPackageRecipeInfo> CODEC = MAP_CODEC.codec();
    public static final StreamCodec<RegistryFriendlyByteBuf, FusionPackageRecipeInfo> STREAM_CODEC = StreamCodec.composite((StreamCodec)ResourceLocation.STREAM_CODEC, FusionPackageRecipeInfo::getRecipeId, (StreamCodec)ItemStack.OPTIONAL_STREAM_CODEC, FusionPackageRecipeInfo::getCoreInput, (StreamCodec)ItemStack.OPTIONAL_LIST_STREAM_CODEC, FusionPackageRecipeInfo::getInjectorInputs, FusionPackageRecipeInfo::new);
    private final ResourceLocation id;
    private final IFusionRecipe recipe;
    private final ItemStack inputCore;
    private final List<ItemStack> inputInjector;
    private final List<ItemStack> input;
    private final ItemStack output;
    private final List<IPackagePattern> patterns = new ArrayList<IPackagePattern>();

    public FusionPackageRecipeInfo(ResourceLocation id, ItemStack inputCore, List<ItemStack> inputInjector) {
        this.id = id;
        this.inputCore = inputCore;
        this.inputInjector = inputInjector;
        ArrayList<ItemStack> matrixList = new ArrayList<ItemStack>(inputInjector.size() + 1);
        matrixList.add(inputCore);
        matrixList.addAll(inputInjector);
        Recipe recipeSer = MiscHelper.INSTANCE.getRecipeManager().byKey(id).map(RecipeHolder::value).orElse(null);
        if (recipeSer instanceof IFusionRecipe) {
            IFusionRecipe fusionRecipe;
            this.recipe = fusionRecipe = (IFusionRecipe)recipeSer;
            ICustomIngredient iCustomIngredient = this.recipe.getCatalyst().getCustomIngredient();
            if (iCustomIngredient instanceof StackIngredient) {
                StackIngredient ingStack = (StackIngredient)iCustomIngredient;
                inputCore.setCount(ingStack.getCount());
            } else {
                inputCore.setCount(1);
            }
            FakeFusionInventory matrix = new FakeFusionInventory();
            matrix.setCatalystStack(inputCore);
            matrix.setInjectorStacks(inputInjector);
            this.output = this.recipe.assemble((RecipeInput)matrix, (HolderLookup.Provider)MiscHelper.INSTANCE.getRegistryAccess()).copy();
        } else {
            this.recipe = null;
            this.output = ItemStack.EMPTY;
        }
        this.input = MiscHelper.INSTANCE.condenseStacks(matrixList);
        int i = 0;
        while (i * 9 < this.input.size()) {
            this.patterns.add((IPackagePattern)new PackagePattern((IPackageRecipeInfo)this, i));
            ++i;
        }
    }

    public FusionPackageRecipeInfo(List<ItemStack> inputs, Level level) {
        ItemStack inputCore = ItemStack.EMPTY;
        this.inputInjector = new ArrayList<ItemStack>();
        int[] slotArray = FusionPackageRecipeType.SLOTS.toIntArray();
        ArrayUtils.shift((int[])slotArray, (int)0, (int)28, (int)1);
        for (int i = 0; i < 55; ++i) {
            ItemStack toSet = inputs.get(slotArray[i]);
            if (toSet.isEmpty()) continue;
            toSet.setCount(1);
            if (i == 0) {
                toSet.setCount(toSet.getMaxStackSize());
                inputCore = toSet;
                continue;
            }
            this.inputInjector.add(toSet.copy());
        }
        this.inputCore = inputCore;
        ArrayList<ItemStack> matrixList = new ArrayList<ItemStack>(this.inputInjector.size() + 1);
        matrixList.add(inputCore);
        matrixList.addAll(this.inputInjector);
        FakeFusionInventory matrix = new FakeFusionInventory();
        matrix.setCatalystStack(inputCore);
        matrix.setInjectorStacks(this.inputInjector);
        RecipeHolder recipeHolder = MiscHelper.INSTANCE.getRecipeManager().getRecipeFor((RecipeType)DraconicAPI.FUSION_RECIPE_TYPE.get(), (RecipeInput)matrix, level).orElse(null);
        if (recipeHolder != null) {
            this.id = recipeHolder.id();
            this.recipe = (IFusionRecipe)recipeHolder.value();
            ICustomIngredient iCustomIngredient = this.recipe.getCatalyst().getCustomIngredient();
            if (iCustomIngredient instanceof StackIngredient) {
                StackIngredient ingStack = (StackIngredient)iCustomIngredient;
                inputCore.setCount(ingStack.getCount());
            } else {
                inputCore.setCount(1);
            }
            this.output = this.recipe.assemble((RecipeInput)matrix, (HolderLookup.Provider)level.registryAccess()).copy();
        } else {
            this.id = null;
            this.recipe = null;
            inputCore.setCount(1);
            this.output = null;
        }
        this.input = MiscHelper.INSTANCE.condenseStacks(matrixList);
        int i = 0;
        while (i * 9 < this.input.size()) {
            this.patterns.add((IPackagePattern)new PackagePattern((IPackageRecipeInfo)this, i));
            ++i;
        }
    }

    public IPackageRecipeType getRecipeType() {
        return FusionPackageRecipeType.INSTANCE;
    }

    public boolean isValid() {
        return this.id != null && this.recipe != null;
    }

    public List<IPackagePattern> getPatterns() {
        return Collections.unmodifiableList(this.patterns);
    }

    @Override
    public ItemStack getCoreInput() {
        return this.inputCore.copy();
    }

    @Override
    public List<ItemStack> getInjectorInputs() {
        return Collections.unmodifiableList(this.inputInjector);
    }

    public List<ItemStack> getInputs() {
        return Collections.unmodifiableList(this.input);
    }

    @Override
    public ItemStack getOutput() {
        return this.output.copy();
    }

    @Override
    public int getTierRequired() {
        return this.recipe.getRecipeTier().index;
    }

    @Override
    public long getEnergyRequired() {
        return this.recipe.getEnergyCost();
    }

    @Override
    public IFusionRecipe getRecipe() {
        return this.recipe;
    }

    @Override
    public ResourceLocation getRecipeId() {
        return this.id;
    }

    public Int2ObjectMap<ItemStack> getEncoderStacks() {
        Int2ObjectOpenHashMap map = new Int2ObjectOpenHashMap();
        int[] slotArray = FusionPackageRecipeType.SLOTS.toIntArray();
        slotArray = ArrayUtils.remove((int[])slotArray, (int)27);
        map.put(40, (Object)this.inputCore);
        for (int i = 0; i < this.inputInjector.size(); ++i) {
            map.put(slotArray[i], (Object)this.inputInjector.get(i));
        }
        return map;
    }

    public boolean equals(Object obj) {
        if (obj instanceof FusionPackageRecipeInfo) {
            FusionPackageRecipeInfo other = (FusionPackageRecipeInfo)obj;
            return MiscHelper.INSTANCE.recipeEquals((IPackageRecipeInfo)this, (Object)this.recipe, (IPackageRecipeInfo)other, (Object)other.recipe);
        }
        return false;
    }

    public int hashCode() {
        return MiscHelper.INSTANCE.recipeHashCode((IPackageRecipeInfo)this, (Object)this.recipe);
    }
}

